/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.CallInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.TxReplayTest")
public class TxReplayTest
extends MultipleCacheManagersTest {
    private static final String VALUE = "value";

    public void testReplay() throws Exception {
        this.assertClusterSize("Wrong cluster size", 3);
        MagicKey key = new MagicKey(this.cache(0), this.cache(1));
        Cache newBackupOwnerCache = this.cache(2);
        TxCommandInterceptor interceptor = TxCommandInterceptor.inject(newBackupOwnerCache);
        EmbeddedTransactionManager transactionManager = (EmbeddedTransactionManager)this.tm(0);
        transactionManager.begin();
        this.cache(0).put((Object)key, (Object)VALUE);
        EmbeddedTransaction transaction = transactionManager.getTransaction();
        transaction.runPrepare();
        AssertJUnit.assertEquals((String)"Wrong transaction status before killing backup owner.", (int)2, (int)transaction.getStatus());
        this.killMember(1);
        this.checkIfTransactionExists(newBackupOwnerCache);
        AssertJUnit.assertEquals((String)"Wrong transaction status after killing backup owner.", (int)2, (int)transaction.getStatus());
        transaction.runCommit(false);
        this.assertNoTransactions();
        AssertJUnit.assertEquals((String)"Wrong number of prepares!", (int)1, (int)interceptor.numberPrepares.get());
        AssertJUnit.assertEquals((String)"Wrong number of commits!", (int)1, (int)interceptor.numberCommits.get());
        AssertJUnit.assertEquals((String)"Wrong number of rollbacks!", (int)0, (int)interceptor.numberRollbacks.get());
        this.checkKeyInDataContainer(key);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TxReplayTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.transaction().useSynchronization(false).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).recovery().disable();
        builder.clustering().hash().numOwners(2).stateTransfer().fetchInMemoryState(true);
        this.createClusteredCaches(3, TestDataSCI.INSTANCE, builder);
    }

    private void checkKeyInDataContainer(Object key) {
        for (Cache cache : this.caches()) {
            DataContainer container = cache.getAdvancedCache().getDataContainer();
            InternalCacheEntry entry = container.get(key);
            AssertJUnit.assertNotNull((String)("Cache '" + String.valueOf(this.address(cache)) + "' does not contain key!"), (Object)entry);
            AssertJUnit.assertEquals((String)("Cache '" + String.valueOf(this.address(cache)) + "' has wrong value!"), (Object)VALUE, (Object)entry.getValue());
        }
    }

    private void checkIfTransactionExists(Cache<Object, Object> cache) {
        TransactionTable table = TestingUtil.extractComponent(cache, TransactionTable.class);
        AssertJUnit.assertFalse((String)"Expected a remote transaction.", (boolean)table.getRemoteTransactions().isEmpty());
    }

    static class TxCommandInterceptor
    extends DDAsyncInterceptor {
        private final AtomicInteger numberPrepares = new AtomicInteger(0);
        private final AtomicInteger numberCommits = new AtomicInteger(0);
        private final AtomicInteger numberRollbacks = new AtomicInteger(0);

        TxCommandInterceptor() {
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            if (!ctx.isOriginLocal()) {
                this.numberPrepares.incrementAndGet();
            }
            return this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            if (!ctx.isOriginLocal()) {
                this.numberCommits.incrementAndGet();
            }
            return this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        }

        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            if (!ctx.isOriginLocal()) {
                this.numberRollbacks.incrementAndGet();
            }
            return this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        }

        public static TxCommandInterceptor inject(Cache cache) {
            AsyncInterceptorChain chain = TestingUtil.extractInterceptorChain(cache);
            if (chain.containsInterceptorType(TxCommandInterceptor.class)) {
                return (TxCommandInterceptor)chain.findInterceptorWithClass(TxCommandInterceptor.class);
            }
            TxCommandInterceptor interceptor = new TxCommandInterceptor();
            chain.addInterceptorBefore((AsyncInterceptor)interceptor, CallInterceptor.class);
            return interceptor;
        }
    }
}

