/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.stream.BaseSetupStreamIteratorTest;
import org.infinispan.test.TestingUtil;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.DistributedStreamIteratorExceptionTest")
public class DistributedStreamIteratorExceptionTest
extends BaseSetupStreamIteratorTest {
    protected DistributedStreamIteratorExceptionTest(CacheMode cacheMode) {
        super(false, cacheMode);
    }

    public DistributedStreamIteratorExceptionTest() {
        this(CacheMode.DIST_SYNC);
    }

    protected InternalDataContainer mockContainer(Throwable t) {
        return (InternalDataContainer)Mockito.when((Object)((InternalDataContainer)Mockito.mock(InternalDataContainer.class)).publisher(ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{t}).getMock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureDataContainerRemoteExceptionPropagated() {
        Cache cache0 = this.cache(0, "testCache");
        Cache cache1 = this.cache(1, "testCache");
        InternalDataContainer dataContainer = TestingUtil.extractComponent(cache1, InternalDataContainer.class);
        try {
            AssertionError t = new AssertionError();
            InternalDataContainer mockContainer = this.mockContainer((Throwable)((Object)t));
            TestingUtil.replaceComponent(cache1, InternalDataContainer.class, mockContainer, true);
            try {
                cache0.entrySet().stream().iterator().hasNext();
                AssertJUnit.fail((String)"We should have gotten a CacheException");
            }
            catch (CacheException e) {
                Throwable cause = e;
                while ((cause = cause.getCause()) != null && !t.getClass().isInstance(cause)) {
                }
                AssertJUnit.assertNotNull((String)"We should have found the throwable as a cause", (Object)cause);
            }
        }
        finally {
            TestingUtil.replaceComponent(cache1, InternalDataContainer.class, dataContainer, true);
        }
    }
}

