/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.stream.BaseStreamTest;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="streams.LocalTxStreamTest")
public class LocalTxStreamTest
extends BaseStreamTest {
    public LocalTxStreamTest() {
        super(true);
        this.cacheMode(CacheMode.LOCAL);
    }

    @Override
    protected <E> CacheStream<E> createStream(CacheCollection<E> entries) {
        return entries.stream();
    }

    @Override
    @Test(enabled=false)
    public void testKeySegmentFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInTransactionWithValues(Map<Integer, String> values, Consumer<CacheSet<Map.Entry<Integer, String>>> setConsumer) throws SystemException, NotSupportedException {
        Cache cache = this.getCache(0);
        this.tm(cache).begin();
        try {
            cache.putAll(values);
            setConsumer.accept((CacheSet<Map.Entry<Integer, String>>)cache.entrySet());
        }
        finally {
            this.tm(cache).rollback();
        }
    }

    public void testTransactionalFindFirstPresent() throws SystemException, NotSupportedException {
        this.testInTransactionWithValues(Map.of(1, "foo"), set -> AssertJUnit.assertTrue((boolean)set.stream().findFirst().isPresent()));
    }

    public void testTransactionalFindFirstFiltered() throws SystemException, NotSupportedException {
        this.testInTransactionWithValues(Map.of(1, "foo"), set -> AssertJUnit.assertTrue((boolean)set.stream().filter((SerializablePredicate & Serializable)e -> ((String)e.getValue()).equals("bar")).findFirst().isEmpty()));
    }

    public void testTransactionalFindFirstInCacheAndTx() throws SystemException, NotSupportedException {
        Cache cache = this.getCache(0);
        cache.put((Object)1, (Object)"original");
        this.testInTransactionWithValues(Map.of(1, "foo"), set -> {
            Optional op = set.stream().findFirst();
            AssertJUnit.assertTrue((boolean)op.isPresent());
            AssertJUnit.assertEquals((String)"foo", (String)((String)((Map.Entry)op.get()).getValue()));
        });
    }
}

