/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="stress.MemoryCleanupTest", description="Designed to be run manually")
public class MemoryCleanupTest {
    @BeforeClass(alwaysRun=true)
    public void createCm() {
    }

    public void testMemoryConsumption() throws InterruptedException {
        int i;
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(config);
        Cache cache = cm.getCache();
        long freeMemBefore = this.freeMemKb();
        System.out.println("freeMemBefore = " + freeMemBefore);
        for (i = 0; i < 307200; ++i) {
            cache.put((Object)i, (Object)i);
        }
        System.out.println("Free memory after: " + this.freeMemKb());
        System.out.println("Consumed memory: " + (freeMemBefore - this.freeMemKb()));
        cm.stop();
        for (i = 0; i < 10; ++i) {
            System.gc();
            if (this.isOkay(freeMemBefore)) break;
            Thread.sleep(1000L);
        }
        System.out.println("Free memory at the end:" + this.freeMemKb());
        assert (this.isOkay(freeMemBefore));
    }

    private boolean isOkay(long freeMemBefore) {
        return (double)freeMemBefore < (double)this.freeMemKb() + 0.1 * (double)this.freeMemKb();
    }

    public long freeMemKb() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }
}

