/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="stress.ReplGetStressTest", timeOut=900000L)
public class ReplGetStressTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 4;
    private static final int NUM_ITERATIONS = Integer.getInteger("operationsCount", 10);
    private static final boolean explicitTxs = Boolean.getBoolean("explicitTxs");

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    public void testStressGetEmptyCache() throws Exception {
        long start = System.nanoTime();
        ConfigurationBuilder replConfig = ReplGetStressTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        for (int i = 0; i < 4; ++i) {
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
            this.defineConfigurationOnAllManagers("repl", replConfig);
            cm.startCaches(new String[]{"repl"});
        }
        System.out.println("Caches created: " + String.valueOf(this.manager(0).getMembers()));
        System.out.println("Explicit txs: " + explicitTxs);
        System.out.println("Operation count: " + NUM_ITERATIONS + "m");
        Cache replCache0 = this.cache(0, "repl");
        for (int i = 0; i < NUM_ITERATIONS * 1000000; ++i) {
            if (explicitTxs) {
                this.tm(0, "repl").begin();
            }
            Object o = replCache0.get((Object)("k" + i));
            AssertJUnit.assertNull((Object)o);
            if (!explicitTxs) continue;
            this.tm(0, "repl").commit();
        }
        long end = System.nanoTime();
        System.out.println("Test took " + TimeUnit.NANOSECONDS.toSeconds(end - start) + "s");
    }
}

