/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;

@Listener(observation=Listener.Observation.POST)
public class ViewChangeListener {
    CacheContainer cm;
    final CountDownLatch latch = new CountDownLatch(1);

    public ViewChangeListener(Cache c) {
        this(c.getCacheManager());
    }

    public ViewChangeListener(EmbeddedCacheManager cm) {
        this.cm = cm;
        cm.addListener((Object)this);
    }

    @ViewChanged
    public void onViewChange(ViewChangedEvent e) {
        this.latch.countDown();
    }

    public void waitForViewChange(long time, TimeUnit unit) throws InterruptedException {
        if (!this.latch.await(time, unit)) assert (false) : "View change not seen after " + time + " " + String.valueOf((Object)unit);
    }
}

