/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import org.infinispan.Cache;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.concurrent.CommandMatcher;
import org.infinispan.test.concurrent.DefaultCommandMatcher;
import org.infinispan.test.concurrent.MatchCountMatcher;

public class CommandMatcherBuilder<T extends ReplicableCommand> {
    private final Class<T> commandClass;
    private String cacheName;
    private Address origin;
    private Object key;
    private int matchCount = -1;

    public CommandMatcherBuilder(Class<T> commandClass) {
        this.commandClass = commandClass;
    }

    public CommandMatcher build() {
        if (this.matchCount < 0) {
            return this.buildInternal();
        }
        return new MatchCountMatcher(this.buildInternal(), this.matchCount);
    }

    private CommandMatcher buildInternal() {
        if (CacheRpcCommand.class.isAssignableFrom(this.commandClass)) {
            return new DefaultCommandMatcher(this.commandClass, this.cacheName, this.origin);
        }
        if (DataCommand.class.isAssignableFrom(this.commandClass)) {
            return new DefaultCommandMatcher(this.commandClass, this.key);
        }
        return new DefaultCommandMatcher(this.commandClass);
    }

    public CommandMatcherBuilder withCache(Cache cache) {
        return this.withCache(cache.getName());
    }

    public CommandMatcherBuilder withCache(String cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    public CommandMatcherBuilder withOrigin(Address origin) {
        this.origin = origin;
        return this;
    }

    public CommandMatcherBuilder localOnly() {
        this.origin = DefaultCommandMatcher.LOCAL_ORIGIN_PLACEHOLDER;
        return this;
    }

    public CommandMatcherBuilder remoteOnly() {
        this.origin = DefaultCommandMatcher.ANY_REMOTE_PLACEHOLDER;
        return this;
    }

    public CommandMatcherBuilder withKey(Object key) {
        this.key = key;
        return this;
    }

    public CommandMatcherBuilder matchCount(int matchCount) {
        this.matchCount = matchCount;
        return this;
    }
}

