/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.concurrent.CacheComponentSequencerAction;
import org.infinispan.test.concurrent.CommandMatcher;
import org.infinispan.test.concurrent.CommandMatcherBuilder;
import org.infinispan.test.concurrent.GlobalComponentSequencerAction;
import org.infinispan.test.concurrent.InboundRpcSequencerAction;
import org.infinispan.test.concurrent.InterceptorSequencerAction;
import org.infinispan.test.concurrent.InvocationMatcher;
import org.infinispan.test.concurrent.InvocationMatcherBuilder;
import org.infinispan.test.concurrent.OutboundRpcSequencerAction;
import org.infinispan.test.concurrent.StateSequencer;

public class StateSequencerUtil {
    public static InterceptorSequencerAction advanceOnInterceptor(StateSequencer stateSequencer, Cache<?, ?> cache, Class<? extends AsyncInterceptor> interceptorClass, CommandMatcher matcher) {
        return new InterceptorSequencerAction(stateSequencer, cache, interceptorClass, matcher);
    }

    public static InboundRpcSequencerAction advanceOnInboundRpc(StateSequencer stateSequencer, Cache cache, CommandMatcher matcher) {
        return new InboundRpcSequencerAction(stateSequencer, cache, matcher);
    }

    public static OutboundRpcSequencerAction advanceOnOutboundRpc(StateSequencer stateSequencer, Cache<?, ?> cache, CommandMatcher matcher) {
        return new OutboundRpcSequencerAction(stateSequencer, cache, matcher);
    }

    public static CacheComponentSequencerAction advanceOnComponentMethod(StateSequencer stateSequencer, Cache<?, ?> cache, Class<?> componentClass, InvocationMatcher matcher) {
        return new CacheComponentSequencerAction(stateSequencer, cache, componentClass, matcher);
    }

    public static <T> GlobalComponentSequencerAction<T> advanceOnGlobalComponentMethod(StateSequencer stateSequencer, EmbeddedCacheManager cacheManager, Class<T> componentClass, InvocationMatcher matcher) {
        return new GlobalComponentSequencerAction<T>(stateSequencer, cacheManager, componentClass, matcher);
    }

    public static CommandMatcherBuilder matchCommand(Class<? extends ReplicableCommand> commandClass) {
        return new CommandMatcherBuilder<ReplicableCommand>(commandClass);
    }

    public static InvocationMatcherBuilder matchMethodCall(String methodName) {
        return new InvocationMatcherBuilder(methodName);
    }

    public static List<String> listCopy(List<String> statesUp) {
        return statesUp != null ? Collections.unmodifiableList(new LinkedList<String>(statesUp)) : null;
    }

    public static List<String> concat(String state1, String ... additionalStates) {
        ArrayList<String> states = new ArrayList<String>();
        states.add(state1);
        if (additionalStates != null) {
            states.addAll(Arrays.asList(additionalStates));
        }
        return states;
    }

    public static void advanceMultiple(StateSequencer stateSequencer, boolean condition, List<String> states) throws TimeoutException, InterruptedException {
        if (condition && states != null) {
            for (String state : states) {
                stateSequencer.advance(state);
            }
        }
    }
}

