/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.transport;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.View;

public final class DelayedViewJGroupsTransport
extends JGroupsTransport {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final CompletableFuture<Void> waitLatch;

    public DelayedViewJGroupsTransport(CompletableFuture<Void> waitLatch) {
        this.waitLatch = waitLatch;
    }

    public void receiveClusterView(View newView, boolean installIfFirst) {
        if (this.getMembers().size() > newView.getMembers().size()) {
            log.debugf("Delaying view %s", (Object)newView);
            this.waitLatch.thenAccept(__ -> {
                log.debugf("Unblocking view %s", (Object)newView);
                super.receiveClusterView(newView, installIfFirst);
            });
        } else {
            super.receiveClusterView(newView, installIfFirst);
        }
    }

    public void assertUnblocked() {
        assert (this.waitLatch.isDone());
    }
}

