/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.AbstractStatefulCluster;
import org.infinispan.topology.ClusterTopologyManager;
import org.testng.annotations.Test;

@Test(testName="topology.ClusterTopologyStatefulTest", groups={"functional"})
public class ClusterTopologyStatefulTest
extends AbstractStatefulCluster {
    public ClusterTopologyStatefulTest() {
        this.clusterSize = 3;
    }

    private AbstractInfinispanTest.Condition allNodesHaveRebalanceDisabled() {
        return () -> Arrays.stream(this.managers()).map(ecm -> TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), ClusterTopologyManager.class)).noneMatch(ClusterTopologyManager::isRebalancingEnabled);
    }

    private Supplier<String> dumpClusterGlobalRebalanceStatus() {
        return () -> Arrays.stream(this.managers()).map(ecm -> Map.entry(ecm, TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), ClusterTopologyManager.class))).map(entry -> String.format("%s is rebalance enabled? %b", ((EmbeddedCacheManager)entry.getKey()).getAddress(), ((ClusterTopologyManager)entry.getValue()).isRebalancingEnabled())).collect(Collectors.joining(System.lineSeparator()));
    }

    private void disableRebalanceAndShutdown() throws Exception {
        ClusterTopologyManager ctm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), ClusterTopologyManager.class);
        ctm.setRebalancingEnabled(false).toCompletableFuture().get(10L, TimeUnit.SECONDS);
        ClusterTopologyStatefulTest.eventually(this.dumpClusterGlobalRebalanceStatus(), this.allNodesHaveRebalanceDisabled());
        TestingUtil.killCacheManagers(this.cacheManagers);
        this.assertClusterStateFiles();
        this.cacheManagers.clear();
    }

    public void testRebalanceAfterRestart() throws Exception {
        this.disableRebalanceAndShutdown();
        this.createStatefulCacheManager(false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.allNodesHaveRebalanceDisabled().isSatisfied()).as(this.dumpClusterGlobalRebalanceStatus())).isTrue();
    }

    public void testOnlyCoordinatorKeepsGlobalState() throws Exception {
        this.disableRebalanceAndShutdown();
        this.createStatefulCacheManager(false, "A");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.allNodesHaveRebalanceDisabled().isSatisfied()).as(this.dumpClusterGlobalRebalanceStatus())).isTrue();
        for (int i = 1; i < this.clusterSize; ++i) {
            this.createStatefulCacheManager(true, Character.toString(65 + i));
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.allNodesHaveRebalanceDisabled().isSatisfied()).as(this.dumpClusterGlobalRebalanceStatus())).isTrue();
    }
}

