/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commands.topology.RebalanceStatusRequestCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.Mocks;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(testName="topology.ClusterTopologyViewChangesTest", groups={"functional"})
public class ClusterTopologyViewChangesTest
extends MultipleCacheManagersTest {
    private final int dataSize = 100;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(this.defaultGlobalConfig(), this.defaultCacheConfig(), 2);
    }

    private GlobalConfigurationBuilder defaultGlobalConfig() {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.transport().distributedSyncTimeout(30L, TimeUnit.SECONDS);
        return gcb;
    }

    private ConfigurationBuilder defaultCacheConfig() {
        ConfigurationBuilder cb = ClusterTopologyViewChangesTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        cb.clustering().stateTransfer().timeout(15L, TimeUnit.SECONDS);
        return cb;
    }

    private EmbeddedCacheManager addNewMember() {
        return this.addClusterEnabledCacheManager(this.defaultGlobalConfig(), this.defaultCacheConfig());
    }

    public void nodeLeftDuringCacheJoin() throws Exception {
        this.executeJoinTest(this.findNonCoordinatorIndex());
    }

    public void coordinatorLeftDuringCacheJoin() throws Exception {
        this.executeJoinTest(this.findCoordinatorIndex());
    }

    public void concurrentJoin() throws Exception {
        this.executeJoinTest(-1);
    }

    public void nodeLeftDuringCacheJoinWithRebalanceDisabled() throws Exception {
        this.waitForClusterToForm();
        TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.findCoordinator()).getClusterTopologyManager().setRebalancingEnabled(false).toCompletableFuture().get(10L, TimeUnit.SECONDS);
        this.executeJoinTest(this.findNonCoordinatorIndex());
    }

    public void coordinatorLeftDuringCacheJoinWithRebalanceDisabled() throws Exception {
        this.waitForClusterToForm();
        TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.findCoordinator()).getClusterTopologyManager().setRebalancingEnabled(false).toCompletableFuture().get(10L, TimeUnit.SECONDS);
        this.executeJoinTest(this.findCoordinatorIndex());
    }

    private void executeJoinTest(int nodeToStop) throws Exception {
        this.populateCache();
        CheckPoint checkPoint = new CheckPoint();
        AtomicBoolean onlyOnce = new AtomicBoolean(true);
        Mocks.blockInboundGlobalCommand(this.findCoordinator(), checkPoint, rpc -> {
            if (rpc instanceof RebalanceStatusRequestCommand) {
                RebalanceStatusRequestCommand rsrc = (RebalanceStatusRequestCommand)rpc;
                return rsrc.getCacheName() == null && onlyOnce.getAndSet(false);
            }
            return false;
        });
        this.waitForClusterToForm();
        Future<EmbeddedCacheManager> joining = this.fork(this::addNewMember);
        checkPoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
        if (nodeToStop < 0) {
            this.addNewMember();
        } else {
            TestingUtil.killCacheManagers((EmbeddedCacheManager)this.cacheManagers.remove(nodeToStop));
        }
        checkPoint.trigger("before_release");
        checkPoint.trigger("after_release");
        log.info((Object)"Waiting for joiner to finish");
        EmbeddedCacheManager joiner = joining.get(10L, TimeUnit.SECONDS);
        boolean rebalanced = TestingUtil.extractGlobalComponentRegistry((CacheContainer)joiner).getClusterTopologyManager().isRebalancingEnabled();
        Assertions.assertThat((boolean)TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.findCoordinator()).getClusterTopologyManager().isRebalancingEnabled()).isEqualTo(rebalanced);
        if (rebalanced) {
            this.assertCacheData();
        }
    }

    private void populateCache() {
        Cache cache = this.cache(0);
        IntStream.range(0, 100).parallel().forEach(i -> cache.put((Object)("key-" + i), (Object)("value-" + i)));
    }

    private void assertCacheData() {
        for (int m = 0; m < this.managers().length; ++m) {
            Cache cache = this.cache(m);
            int size = cache.size();
            ((AbstractIntegerAssert)Assertions.assertThat((int)size).withFailMessage(String.format("Cache %d has %d/%d entries", m, size, 100), new Object[0])).isEqualTo(100);
            for (int i = 0; i < 100; ++i) {
                Assertions.assertThat((String)((String)cache.get((Object)("key-" + i)))).isEqualTo("value-" + i);
            }
        }
    }

    private EmbeddedCacheManager findCoordinator() {
        return this.manager(this.findCoordinatorIndex());
    }

    private int findCoordinatorIndex() {
        for (int i = 0; i < this.managers().length; ++i) {
            if (!this.manager(i).isCoordinator()) continue;
            return i;
        }
        throw new IllegalStateException("Coordinator node not found");
    }

    private int findNonCoordinatorIndex() {
        for (int i = 0; i < this.managers().length; ++i) {
            if (this.manager(i).isCoordinator()) continue;
            return i;
        }
        throw new IllegalStateException("There are only coordinators?");
    }
}

