/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUID;
import org.testng.AssertJUnit;

public class TestClusterCacheStatus {
    private final CacheJoinInfo joinInfo;
    private CacheTopology topology;
    private CacheTopology stableTopology;

    public TestClusterCacheStatus(CacheJoinInfo joinInfo, CacheTopology topology, CacheTopology stableTopology) {
        this.joinInfo = joinInfo;
        this.topology = topology;
        AssertJUnit.assertNull((Object)stableTopology.getPendingCH());
        this.stableTopology = stableTopology;
    }

    public static TestClusterCacheStatus start(CacheJoinInfo joinInfo, Address ... members) {
        List<Address> membersList = Arrays.asList(members);
        return TestClusterCacheStatus.start(joinInfo, membersList);
    }

    public static TestClusterCacheStatus start(CacheJoinInfo joinInfo, List<Address> members) {
        ConsistentHash currentCH = joinInfo.getConsistentHashFactory().create(joinInfo.getNumOwners(), joinInfo.getNumSegments(), members, null);
        CacheTopology topology = new CacheTopology(1, 1, currentCH, null, null, CacheTopology.Phase.NO_REBALANCE, members, TestClusterCacheStatus.persistentUUIDs(members));
        return new TestClusterCacheStatus(joinInfo, topology, topology);
    }

    public TestClusterCacheStatus copy() {
        return new TestClusterCacheStatus(this.joinInfo, this.topology, this.stableTopology);
    }

    public void startRebalance(CacheTopology.Phase phase, Address ... targetMembers) {
        this.startRebalance(phase, Arrays.asList(targetMembers));
    }

    public void startRebalance(CacheTopology.Phase phase, List<Address> targetMembers) {
        AssertJUnit.assertNull((Object)this.topology.getPendingCH());
        AssertJUnit.assertTrue((boolean)targetMembers.containsAll(this.topology.getCurrentCH().getMembers()));
        ConsistentHash pendingCH = this.joinInfo.getConsistentHashFactory().updateMembers(this.topology.getCurrentCH(), targetMembers, null);
        pendingCH = this.joinInfo.getConsistentHashFactory().rebalance(pendingCH);
        this.topology = new CacheTopology(this.topology.getTopologyId() + 1, this.topology.getRebalanceId() + 1, this.topology.getCurrentCH(), pendingCH, null, phase, targetMembers, TestClusterCacheStatus.persistentUUIDs(targetMembers));
    }

    public void advanceRebalance(CacheTopology.Phase phase) {
        this.topology = new CacheTopology(this.topology.getTopologyId() + 1, this.topology.getRebalanceId(), this.topology.getCurrentCH(), this.topology.getPendingCH(), this.topology.getUnionCH(), phase, this.topology.getActualMembers(), TestClusterCacheStatus.persistentUUIDs(this.topology.getMembers()));
    }

    public void finishRebalance() {
        this.topology = new CacheTopology(this.topology.getTopologyId() + 1, this.topology.getRebalanceId(), this.topology.getPendingCH(), null, null, CacheTopology.Phase.NO_REBALANCE, this.topology.getActualMembers(), TestClusterCacheStatus.persistentUUIDs(this.topology.getActualMembers()));
    }

    public void cancelRebalance() {
        AssertJUnit.assertNotSame((Object)CacheTopology.Phase.NO_REBALANCE, (Object)this.topology.getPhase());
        AssertJUnit.assertNotSame((Object)CacheTopology.Phase.CONFLICT_RESOLUTION, (Object)this.topology.getPhase());
        this.topology = new CacheTopology(this.topology.getTopologyId() + 1, this.topology.getRebalanceId() + 1, this.readConsistentHash(), null, null, CacheTopology.Phase.NO_REBALANCE, this.topology.getActualMembers(), TestClusterCacheStatus.persistentUUIDs(this.topology.getActualMembers()));
    }

    public ConsistentHash readConsistentHash() {
        return AvailabilityStrategy.ownersConsistentHash((CacheTopology)this.topology, (ConsistentHashFactory)this.joinInfo.getConsistentHashFactory());
    }

    public void updateStableTopology() {
        AssertJUnit.assertEquals((Object)CacheTopology.Phase.NO_REBALANCE, (Object)this.topology.getPhase());
        this.stableTopology = this.topology;
    }

    public void removeMembers(Address ... leavers) {
        this.removeMembers(Arrays.asList(leavers));
    }

    public void removeMembers(List<Address> leavers) {
        ArrayList<Address> updatedMembers = new ArrayList<Address>(this.topology.getActualMembers());
        updatedMembers.removeAll(leavers);
        AssertJUnit.assertEquals((int)this.topology.getActualMembers().size(), (int)(leavers.size() + updatedMembers.size()));
        ConsistentHash updatedCH = this.joinInfo.getConsistentHashFactory().updateMembers(this.topology.getCurrentCH(), updatedMembers, null);
        ConsistentHash updatedPendingCH = this.topology.getPendingCH() != null ? this.joinInfo.getConsistentHashFactory().updateMembers(this.topology.getPendingCH(), updatedMembers, null) : null;
        ConsistentHash updatedUnionCH = this.topology.getUnionCH() != null ? this.joinInfo.getConsistentHashFactory().updateMembers(this.topology.getUnionCH(), updatedMembers, null) : null;
        this.topology = new CacheTopology(this.topology.getTopologyId() + 1, this.topology.getRebalanceId(), updatedCH, updatedPendingCH, updatedUnionCH, this.topology.getPhase(), updatedMembers, TestClusterCacheStatus.persistentUUIDs(updatedMembers));
    }

    public void startConflictResolution(ConsistentHash conflictCH, Address ... mergeMembers) {
        this.startConflictResolution(conflictCH, Arrays.asList(mergeMembers));
    }

    public void startConflictResolution(ConsistentHash conflictCH, List<Address> mergeMembers) {
        this.topology = new CacheTopology(this.topology.getTopologyId() + 1, this.topology.getRebalanceId() + 1, conflictCH, null, CacheTopology.Phase.CONFLICT_RESOLUTION, mergeMembers, TestClusterCacheStatus.persistentUUIDs(mergeMembers));
    }

    public static ConsistentHash conflictResolutionConsistentHash(TestClusterCacheStatus ... caches) {
        ConsistentHashFactory chf = caches[0].joinInfo.getConsistentHashFactory();
        ConsistentHash hash = Stream.of(caches).map(TestClusterCacheStatus::readConsistentHash).reduce((arg_0, arg_1) -> ((ConsistentHashFactory)chf).union(arg_0, arg_1)).orElseThrow(IllegalStateException::new);
        return chf.union(hash, chf.rebalance(hash));
    }

    public ConsistentHash ch(Address ... addresses) {
        return this.joinInfo.getConsistentHashFactory().create(this.joinInfo.getNumOwners(), this.joinInfo.getNumSegments(), Arrays.asList(addresses), null);
    }

    public static PersistentUUID persistentUUID(Address a) {
        return new PersistentUUID((long)a.hashCode(), (long)a.hashCode());
    }

    private static List<PersistentUUID> persistentUUIDs(List<Address> members) {
        return members.stream().map(TestClusterCacheStatus::persistentUUID).collect(Collectors.toList());
    }

    public CacheJoinInfo joinInfo(Address a) {
        return new CacheJoinInfo(this.joinInfo.getConsistentHashFactory(), this.joinInfo.getNumSegments(), this.joinInfo.getNumOwners(), this.joinInfo.getTimeout(), this.joinInfo.getCacheMode(), this.joinInfo.getCapacityFactor(), TestClusterCacheStatus.persistentUUID(a), this.joinInfo.getPersistentStateChecksum());
    }

    public CacheTopology topology() {
        return this.topology;
    }

    public CacheTopology stableTopology() {
        return this.stableTopology;
    }

    public void incrementIds(int topologyIdDelta, int rebalanceIdDelta) {
        this.topology = new CacheTopology(this.topology.getTopologyId() + topologyIdDelta, this.topology.getRebalanceId() + rebalanceIdDelta, this.topology.getCurrentCH(), this.topology.getPendingCH(), this.topology.getUnionCH(), this.topology.getPhase(), this.topology.getActualMembers(), this.topology.getMembersPersistentUUIDs());
    }

    public void incrementStableIds(int topologyIdDelta, int rebalanceIdDelta) {
        AssertJUnit.assertSame((Object)CacheTopology.Phase.NO_REBALANCE, (Object)this.stableTopology.getPhase());
        AssertJUnit.assertNull((Object)this.stableTopology.getPendingCH());
        AssertJUnit.assertNull((Object)this.stableTopology.getUnionCH());
        this.stableTopology = new CacheTopology(this.stableTopology.getTopologyId() + topologyIdDelta, this.stableTopology.getRebalanceId() + rebalanceIdDelta, this.stableTopology.getCurrentCH(), null, null, this.stableTopology.getPhase(), this.stableTopology.getActualMembers(), this.stableTopology.getMembersPersistentUUIDs());
    }

    public void incrementIds() {
        this.incrementIds(1, 1);
    }

    public void incrementIdsIfNeeded(TestClusterCacheStatus ... otherPartitions) {
        int newTopologyId = this.topology.getTopologyId();
        int newRebalanceId = this.topology.getRebalanceId();
        for (TestClusterCacheStatus cache : otherPartitions) {
            newTopologyId = Math.max(cache.topology.getTopologyId() + 1, newTopologyId);
            newRebalanceId = Math.max(cache.topology.getRebalanceId() + 1, newRebalanceId);
        }
        this.topology = new CacheTopology(newTopologyId, newRebalanceId, this.topology.getCurrentCH(), this.topology.getPendingCH(), this.topology.getUnionCH(), this.topology.getPhase(), this.topology.getActualMembers(), this.topology.getMembersPersistentUUIDs());
    }

    public void updateActualMembers(Address ... actualMembers) {
        this.updateActualMembers(Arrays.asList(actualMembers));
    }

    public void updateActualMembers(List<Address> actualMembers) {
        AssertJUnit.assertTrue((boolean)this.topology.getMembers().containsAll(actualMembers));
        this.topology = new CacheTopology(this.topology.getTopologyId() + 1, this.topology.getRebalanceId() + 1, this.topology.getCurrentCH(), this.topology.getPendingCH(), this.topology.getUnionCH(), this.topology.getPhase(), actualMembers, TestClusterCacheStatus.persistentUUIDs(actualMembers));
    }
}

