/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.EmbeddedTransactionManagerRollbackTest")
public class EmbeddedTransactionManagerRollbackTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.transaction().useSynchronization(true);
        builder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testCallerReceivesException() {
        Cache c = this.cache();
        TestingUtil.extractInterceptorChain(c).addInterceptor((AsyncInterceptor)new FailInterceptor(), 2);
        Assertions.assertThatThrownBy(() -> c.putAsync((Object)"key", (Object)"value").get(10L, TimeUnit.SECONDS)).hasMessageContaining("Oops");
        this.assertNoTransactions(c);
    }

    static class FailInterceptor
    extends DDAsyncInterceptor {
        FailInterceptor() {
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.invokeNextAndFinally(ctx, (VisitableCommand)command, (rCtx, rCommand, rv, throwable) -> {
                throw new RuntimeException("Oops");
            });
        }
    }
}

