/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.FailureWith1PCTest")
public class FailureWith1PCTest
extends MultipleCacheManagersTest {
    boolean fail = true;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = FailureWith1PCTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        c.clustering().hash().numOwners(3);
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    public void testInducedFailureOn1pc() throws Exception {
        TestingUtil.extractInterceptorChain(this.cache(1)).addInterceptor((AsyncInterceptor)new FailInterceptor(), 1);
        this.tm(0).begin();
        this.cache(0).put((Object)"k", (Object)"v");
        try {
            this.tm(0).commit();
            assert (false) : "Exception expected";
        }
        catch (Exception e) {
            log.debug((Object)"Ignoring expected exception during 1-phase prepare", (Throwable)e);
        }
        this.fail = false;
        this.assertExpectedState(0);
        this.assertExpectedState(1);
        this.assertExpectedState(2);
    }

    private void assertExpectedState(int index) {
        Assert.assertNull((Object)this.cache(index).get((Object)"k"));
        assert (!this.lockManager(index).isLocked((Object)"k"));
        assert (TestingUtil.getTransactionTable(this.cache(index)).getLocalTxCount() == 0);
        assert (TestingUtil.getTransactionTable(this.cache(index)).getRemoteTxCount() == 0);
    }

    class FailInterceptor
    extends DDAsyncInterceptor {
        FailInterceptor() {
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            if (FailureWith1PCTest.this.fail) {
                throw new RuntimeException("Induced exception");
            }
            return this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        }
    }
}

