/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.impl.ModificationList;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ModificationListUnitTest")
public class ModificationListUnitTest
extends AbstractInfinispanTest {
    private static WriteCommand mockCommand(boolean cacheModeLocalFlag) {
        WriteCommand cmd = (WriteCommand)Mockito.mock(WriteCommand.class);
        Mockito.when((Object)cmd.hasAnyFlag(ArgumentMatchers.anyLong())).thenReturn((Object)cacheModeLocalFlag);
        return cmd;
    }

    public void testZeroAndNegativeCapacity() {
        Exceptions.expectException(IllegalArgumentException.class, () -> new ModificationList(0));
        Exceptions.expectException(IllegalArgumentException.class, () -> new ModificationList(-1));
    }

    public void testGrow() {
        int i;
        ModificationList modsList = new ModificationList(1);
        int expectedSize = 5;
        for (i = 0; i < expectedSize; ++i) {
            modsList.append(ModificationListUnitTest.mockCommand(true));
        }
        AssertJUnit.assertEquals((int)expectedSize, (int)modsList.size());
        AssertJUnit.assertEquals((int)expectedSize, (int)modsList.getAllModifications().size());
        AssertJUnit.assertEquals((int)0, (int)modsList.getModifications().size());
        for (i = 0; i < expectedSize; ++i) {
            modsList.append(ModificationListUnitTest.mockCommand(false));
        }
        AssertJUnit.assertEquals((int)(expectedSize * 2), (int)modsList.size());
        AssertJUnit.assertEquals((int)(expectedSize * 2), (int)modsList.getAllModifications().size());
        AssertJUnit.assertEquals((int)expectedSize, (int)modsList.getModifications().size());
    }

    public void testFreeze() {
        List<WriteCommand> commands = Arrays.asList(ModificationListUnitTest.mockCommand(false), ModificationListUnitTest.mockCommand(false), ModificationListUnitTest.mockCommand(false));
        ModificationList modsList = ModificationList.fromCollection(commands);
        AssertJUnit.assertEquals((int)commands.size(), (int)modsList.size());
        AssertJUnit.assertEquals((int)commands.size(), (int)modsList.getModifications().size());
        AssertJUnit.assertEquals((int)commands.size(), (int)modsList.getAllModifications().size());
        modsList.freeze();
        Exceptions.expectException(IllegalStateException.class, () -> modsList.append(ModificationListUnitTest.mockCommand(false)));
        Exceptions.expectException(IllegalStateException.class, () -> modsList.append(ModificationListUnitTest.mockCommand(true)));
    }

    public void testModsOrder() {
        List<WriteCommand> commands = Arrays.asList(ModificationListUnitTest.mockCommand(false), ModificationListUnitTest.mockCommand(true), ModificationListUnitTest.mockCommand(false));
        ModificationList modsList = ModificationList.fromCollection(commands);
        AssertJUnit.assertEquals((int)commands.size(), (int)modsList.size());
        AssertJUnit.assertFalse((boolean)modsList.isEmpty());
        AssertJUnit.assertEquals((int)2, (int)modsList.getModifications().size());
        AssertJUnit.assertEquals((int)3, (int)modsList.getAllModifications().size());
        AssertJUnit.assertTrue((boolean)modsList.hasNonLocalModifications());
        AssertJUnit.assertEquals(commands, (Object)modsList.getAllModifications());
        AssertJUnit.assertEquals(Arrays.asList(commands.get(0), commands.get(2)), (Object)modsList.getModifications());
    }

    public void testSnapshot() {
        List<WriteCommand> commands = Arrays.asList(ModificationListUnitTest.mockCommand(false), ModificationListUnitTest.mockCommand(true), ModificationListUnitTest.mockCommand(false));
        ModificationList modsList = ModificationList.fromCollection(commands);
        List allCommands = modsList.getAllModifications();
        List nonLocalCommands = modsList.getModifications();
        AssertJUnit.assertEquals((int)commands.size(), (int)modsList.size());
        AssertJUnit.assertTrue((boolean)modsList.hasNonLocalModifications());
        AssertJUnit.assertEquals((int)2, (int)nonLocalCommands.size());
        AssertJUnit.assertEquals((int)3, (int)allCommands.size());
        AssertJUnit.assertEquals(commands, (Object)allCommands);
        AssertJUnit.assertEquals(Arrays.asList(commands.get(0), commands.get(2)), (Object)nonLocalCommands);
        modsList.append(ModificationListUnitTest.mockCommand(false));
        AssertJUnit.assertEquals((int)(commands.size() + 1), (int)modsList.size());
        AssertJUnit.assertEquals((int)2, (int)nonLocalCommands.size());
        AssertJUnit.assertEquals((int)3, (int)allCommands.size());
        AssertJUnit.assertEquals(commands, (Object)allCommands);
        AssertJUnit.assertEquals(Arrays.asList(commands.get(0), commands.get(2)), (Object)nonLocalCommands);
        modsList.append(ModificationListUnitTest.mockCommand(true));
        AssertJUnit.assertEquals((int)(commands.size() + 2), (int)modsList.size());
        AssertJUnit.assertEquals((int)2, (int)nonLocalCommands.size());
        AssertJUnit.assertEquals((int)3, (int)allCommands.size());
        AssertJUnit.assertEquals(commands, (Object)allCommands);
        AssertJUnit.assertEquals(Arrays.asList(commands.get(0), commands.get(2)), (Object)nonLocalCommands);
    }
}

