/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="tx.RemoteLockCleanupStressTest", invocationCount=20, description="original group: functional")
@CleanupAfterMethod
public class RemoteLockCleanupStressTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(RemoteLockCleanupStressTest.class);
    private final String key = "locked-counter";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = RemoteLockCleanupStressTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        c.clustering().stateTransfer().fetchInMemoryState(true).locking().lockAcquisitionTimeout(1500L);
        this.createClusteredCaches(2, c);
    }

    public void testLockRelease() {
        EmbeddedCacheManager cm1 = this.manager(0);
        EmbeddedCacheManager cm2 = this.manager(1);
        Thread t1 = new Thread(new CounterTask(cm1));
        Thread t2 = new Thread(new CounterTask(cm2));
        t1.start();
        t2.start();
        TestingUtil.sleepThread(1000L);
        t2.interrupt();
        TestingUtil.killCacheManagers(cm2);
        this.cacheManagers.remove(1);
        TestingUtil.sleepThread(1100L);
        t1.interrupt();
        LockManager lm = TestingUtil.extractComponent(cm1.getCache(), LockManager.class);
        Object owner = lm.getOwner((Object)"locked-counter");
        assert (this.ownerIsLocalOrUnlocked(owner, cm1.getAddress())) : "Bad lock owner " + String.valueOf(owner);
    }

    private boolean ownerIsLocalOrUnlocked(Object owner, Address self) {
        if (owner == null) {
            return true;
        }
        if (owner instanceof GlobalTransaction) {
            GlobalTransaction gtx = (GlobalTransaction)owner;
            return gtx.getAddress().equals((Object)self);
        }
        return false;
    }

    class CounterTask
    implements Runnable {
        EmbeddedCacheManager cm;

        CounterTask(EmbeddedCacheManager cm) {
            this.cm = cm;
        }

        @Override
        public void run() {
            for (int i = 0; i < 25; ++i) {
                this.run_();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run_() {
            Cache cache = this.cm.getCache();
            TransactionManager tx = cache.getAdvancedCache().getTransactionManager();
            try {
                tx.begin();
            }
            catch (Exception ex) {
                log.debug((Object)"Exception starting transaction", (Throwable)ex);
            }
            try {
                log.debug((Object)("aquiring lock on cache " + cache.getName() + " key locked-counter..."));
                cache.getAdvancedCache().lock(new Object[]{"locked-counter"});
                Integer val = (Integer)cache.get((Object)"locked-counter");
                log.debug((Object)("current value : " + val));
                if (val == null) {
                    val = 0;
                } else {
                    Integer n = val;
                    val = val + 1;
                }
                cache.put((Object)"locked-counter", (Object)val);
                TestingUtil.sleepRandom(200);
                log.debug((Object)"commit...");
                tx.commit();
                log.debug((Object)"done commit");
            }
            catch (Exception ex) {
                try {
                    log.debug((Object)("rollback... " + ex.getLocalizedMessage()));
                    tx.rollback();
                    log.debug((Object)"done rollback");
                }
                catch (Exception rex) {
                    log.debug((Object)"Exception rolling back", (Throwable)rex);
                }
            }
            finally {
                try {
                    log.debug((Object)"tx status at the end : ");
                    switch (tx.getStatus()) {
                        case 0: {
                            log.debug((Object)"active");
                            break;
                        }
                        case 3: {
                            log.debug((Object)"committed");
                            break;
                        }
                        case 8: {
                            log.debug((Object)"committing");
                            break;
                        }
                        case 1: {
                            log.debug((Object)"makerd rollback");
                            break;
                        }
                        case 6: {
                            log.debug((Object)"no transaction");
                            break;
                        }
                        case 2: {
                            log.debug((Object)"preprared");
                            break;
                        }
                        case 7: {
                            log.debug((Object)"preparing");
                            break;
                        }
                        case 4: {
                            log.debug((Object)"rolledback");
                            break;
                        }
                        case 9: {
                            log.debug((Object)"rolling back");
                            break;
                        }
                        case 5: {
                            log.debug((Object)"unknown");
                            break;
                        }
                        default: {
                            log.debug((Object)tx.getStatus());
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)"Exception retrieving transaction status", (Throwable)ex);
                }
            }
        }
    }
}

