/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.concurrent.ConditionFuture;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="util.concurrent.ConditionFutureTest")
public class ConditionFutureTest
extends AbstractInfinispanTest {
    ScheduledExecutorService timeoutExecutor = Executors.newSingleThreadScheduledExecutor(this.getTestThreadFactory("timeout"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.timeoutExecutor.shutdownNow();
    }

    public void testBeforeFirstUpdate() {
        ConditionFuture conditionFuture = new ConditionFuture(this.timeoutExecutor);
        CompletionStage stage = conditionFuture.newConditionStage(i -> i > 0, 10L, TimeUnit.SECONDS);
        AssertJUnit.assertFalse((boolean)stage.toCompletableFuture().isDone());
        conditionFuture.update((Object)1);
        AssertJUnit.assertTrue((boolean)stage.toCompletableFuture().isDone());
    }

    public void testAlreadyCompleted() {
        ConditionFuture conditionFuture = new ConditionFuture(this.timeoutExecutor);
        conditionFuture.update((Object)1);
        CompletionStage stage = conditionFuture.newConditionStage(i -> i > 0, 10L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((boolean)stage.toCompletableFuture().isDone());
    }

    public void testConcurrentModification() {
        ConditionFuture conditionFuture = new ConditionFuture(this.timeoutExecutor);
        CompletionStage stage11 = conditionFuture.newConditionStage(i -> i > 0, 10L, TimeUnit.SECONDS);
        CompletionStage stage12 = conditionFuture.newConditionStage(i -> i > 0, 10L, TimeUnit.SECONDS);
        CompletableFuture<Object> updateReleased = new CompletableFuture<Object>();
        stage11.thenRun(updateReleased::join);
        stage12.thenRun(updateReleased::join);
        conditionFuture.updateAsync((Object)1, (Executor)this.testExecutor());
        ConditionFutureTest.eventually(() -> CompletionStages.isCompletedSuccessfully((CompletionStage)stage11) || CompletionStages.isCompletedSuccessfully((CompletionStage)stage12));
        CompletionStage stage21 = conditionFuture.newConditionStage(i -> i > 1, 10L, TimeUnit.SECONDS);
        CompletionStage stage22 = conditionFuture.newConditionStage(i -> i > 1, 10L, TimeUnit.SECONDS);
        updateReleased.complete(null);
        CompletionStages.join((CompletionStage)stage11);
        CompletionStages.join((CompletionStage)stage12);
        conditionFuture.update((Object)2);
        CompletionStages.join((CompletionStage)stage21);
        CompletionStages.join((CompletionStage)stage22);
    }

    public void testUpdateAsyncException() {
        ConditionFuture conditionFuture = new ConditionFuture(this.timeoutExecutor);
        CompletionStage stage1 = conditionFuture.newConditionStage(i -> i > 0, 10L, TimeUnit.SECONDS);
        ExecutorService executor = Executors.newSingleThreadExecutor(this.getTestThreadFactory(""));
        executor.shutdown();
        conditionFuture.updateAsync((Object)1, (Executor)executor);
        Exceptions.expectCompletionException(RejectedExecutionException.class, (CompletionStage)stage1);
    }

    public void testStopException() {
        ConditionFuture conditionFuture = new ConditionFuture(this.timeoutExecutor);
        CompletionStage stage = conditionFuture.newConditionStage(i -> i > 1, 10L, TimeUnit.SECONDS);
        AssertJUnit.assertFalse((boolean)stage.toCompletableFuture().isDone());
        conditionFuture.stop();
        Exceptions.expectCompletionException(IllegalLifecycleStateException.class, (CompletionStage)stage);
    }

    public void testDuplicatePredicate() {
        ConditionFuture conditionFuture = new ConditionFuture(this.timeoutExecutor);
        Predicate<Integer> test = i -> i > 0;
        CompletionStage stage1 = conditionFuture.newConditionStage(test, 10L, TimeUnit.SECONDS);
        CompletionStage stage2 = conditionFuture.newConditionStage(test, 10L, TimeUnit.SECONDS);
        AssertJUnit.assertFalse((boolean)stage1.toCompletableFuture().isDone());
        AssertJUnit.assertFalse((boolean)stage2.toCompletableFuture().isDone());
        conditionFuture.update((Object)1);
        AssertJUnit.assertTrue((boolean)stage1.toCompletableFuture().isDone());
        AssertJUnit.assertTrue((boolean)stage2.toCompletableFuture().isDone());
    }
}

