/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.versioning.irac.DefaultIracTombstoneManager;
import org.infinispan.xsite.AbstractXSiteTest;
import org.testng.AssertJUnit;

public abstract class AbstractMultipleSitesTest
extends AbstractXSiteTest {
    private static final int MAX_NUM_SITE = 3;
    private static final String[] SITE_NAME = new String[]{"LON-1", "NYC-2", "SFO-3"};

    protected int defaultNumberOfSites() {
        return 2;
    }

    protected int defaultNumberOfNodes() {
        return 2;
    }

    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        return AbstractMultipleSitesTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
    }

    protected GlobalConfigurationBuilder defaultGlobalConfigurationForSite(int siteIndex) {
        return GlobalConfigurationBuilder.defaultClusteredBuilder();
    }

    protected final String siteName(int siteIndex) {
        this.assertValidSiteIndex(siteIndex);
        return SITE_NAME[siteIndex];
    }

    protected void afterSitesCreated() {
    }

    @Override
    protected void createSites() {
        int numberOfSites = this.defaultNumberOfSites();
        if (numberOfSites <= 0) {
            throw new IllegalArgumentException("Default number of sites must be positive.");
        }
        if (numberOfSites > 3) {
            throw new IllegalArgumentException("Default number of sites must be less than the max number of configured sites.");
        }
        for (int siteIndex = 0; siteIndex < this.defaultNumberOfSites(); ++siteIndex) {
            this.createSite(this.siteName(siteIndex), this.defaultNumberOfNodes(), this.defaultGlobalConfigurationForSite(siteIndex), this.defaultConfigurationForSite(siteIndex));
        }
        this.waitForSites();
        this.afterSitesCreated();
    }

    protected void restartSite(int siteIndex) {
        AbstractXSiteTest.TestSite site = this.site(siteIndex);
        AssertJUnit.assertTrue((boolean)site.cacheManagers.isEmpty());
        site.createClusteredCaches(this.defaultNumberOfNodes(), null, this.defaultGlobalConfigurationForSite(siteIndex), this.defaultConfigurationForSite(siteIndex), true);
        this.waitForSites();
    }

    private void assertValidSiteIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Site index must be positive or zero.");
        }
        if (index >= 3) {
            throw new IllegalArgumentException("Site index must be less than the max number of configured sites.");
        }
        if (index >= this.defaultNumberOfSites()) {
            throw new IllegalArgumentException("Site index must be less than the number of sites configured.");
        }
    }

    protected static void defineInSite(AbstractXSiteTest.TestSite site, String cacheName, Configuration configuration) {
        site.cacheManagers().forEach(cacheManager -> cacheManager.defineConfiguration(cacheName, configuration));
    }

    protected <K, V> void assertInAllSitesAndCaches(AbstractXSiteTest.AssertCondition<K, V> condition) {
        this.assertInAllSitesAndCaches(null, condition);
    }

    protected <K, V> void assertInAllSitesAndCaches(String cacheName, AbstractXSiteTest.AssertCondition<K, V> condition) {
        for (AbstractXSiteTest.TestSite testSite : this.sites) {
            this.assertInSite(testSite.getSiteName(), cacheName, condition);
        }
    }

    protected <K, V> void eventuallyAssertInAllSitesAndCaches(AbstractXSiteTest.EventuallyAssertCondition<K, V> condition) {
        this.eventuallyAssertInAllSitesAndCaches(null, condition);
    }

    protected <K, V> void eventuallyAssertInAllSitesAndCaches(String cacheName, AbstractXSiteTest.EventuallyAssertCondition<K, V> condition) {
        for (AbstractXSiteTest.TestSite testSite : this.sites) {
            this.assertEventuallyInSite(testSite.getSiteName(), cacheName, condition, 30L, TimeUnit.SECONDS);
        }
    }

    protected void assertNoDataLeak(String cacheName) {
        for (AbstractXSiteTest.TestSite site : this.sites) {
            for (Cache cache : site.getCaches(cacheName)) {
                this.eventually("Updated keys map is not empty!", () -> this.isIracManagerEmpty(cache));
            }
        }
        for (AbstractXSiteTest.TestSite site : this.sites) {
            for (Cache cache : site.getCaches(cacheName)) {
                this.iracTombstoneManager(cache).startCleanupTombstone();
            }
        }
        for (AbstractXSiteTest.TestSite site : this.sites) {
            for (Cache cache : site.getCaches(cacheName)) {
                this.eventually("Tombstone map is not empty!", () -> ((DefaultIracTombstoneManager)this.iracTombstoneManager(cache)).isEmpty());
            }
        }
    }
}

