/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.infinispan.util.ExponentialBackOff;
import org.testng.AssertJUnit;

public class ControlledExponentialBackOff
implements ExponentialBackOff {
    private String name;
    private final BlockingDeque<Event> backOffEvents;
    private volatile CompletableFuture<Void> backOff = new CompletableFuture();

    ControlledExponentialBackOff() {
        this.backOffEvents = new LinkedBlockingDeque<Event>();
    }

    ControlledExponentialBackOff(String name) {
        this();
        this.name = name;
    }

    public void reset() {
        this.backOffEvents.add(Event.RESET);
    }

    public CompletionStage<Void> asyncBackOff() {
        CompletableFuture<Void> stage = this.backOff;
        this.backOffEvents.add(Event.BACK_OFF);
        return stage;
    }

    void release() {
        CompletableFuture<Void> cs = this.backOff;
        this.backOff = new CompletableFuture();
        cs.complete(null);
    }

    void cleanupEvents() {
        this.backOffEvents.clear();
    }

    void eventually(String message, Event ... expected) {
        ArrayList<Event> events = new ArrayList<Event>(Arrays.asList(expected));
        while (!events.isEmpty()) {
            Event current = null;
            try {
                current = this.backOffEvents.poll(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                AssertJUnit.fail((String)e.getMessage());
            }
            AssertJUnit.assertTrue((String)("At " + this.name + ": " + message + " Expected " + String.valueOf(events) + ", current " + String.valueOf((Object)current)), (boolean)events.contains((Object)current));
            events.remove((Object)current);
        }
    }

    void containsOnly(String message, Event event) {
        while (!this.backOffEvents.isEmpty()) {
            this.eventually(message, event);
        }
    }

    void assertNoEvents() {
        AssertJUnit.assertTrue((String)("At " + this.name + ": Expected no events, found: " + String.valueOf(this.backOffEvents)), (boolean)this.backOffEvents.isEmpty());
    }

    static enum Event {
        BACK_OFF,
        RESET;

    }
}

