/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.offline.ClusteredOfflineStatusTest")
public class ClusteredOfflineStatusTest
extends AbstractMultipleSitesTest {
    private static final String REMOTE_SITE_NAME = "_NYC_";

    @Override
    protected int defaultNumberOfNodes() {
        return 1;
    }

    @Override
    protected int defaultNumberOfSites() {
        return 1;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = super.defaultConfigurationForSite(siteIndex);
        builder.sites().addBackup().site(REMOTE_SITE_NAME);
        return builder;
    }

    public void testJoinerReceivesStatus() {
        DefaultTakeOfflineManager tom1 = this.takeOfflineManager(this.siteName(0), 0);
        tom1.takeSiteOffline(REMOTE_SITE_NAME);
        ClusteredOfflineStatusTest.eventually(() -> tom1.getOfflineStatus(REMOTE_SITE_NAME).isOffline());
        this.site(0).addCache(this.defaultGlobalConfigurationForSite(0), this.defaultConfigurationForSite(0));
        this.site(0).waitForClusterToForm(null);
        DefaultTakeOfflineManager tom2 = this.takeOfflineManager(this.siteName(0), 1);
        ClusteredOfflineStatusTest.eventually(() -> tom2.getOfflineStatus(REMOTE_SITE_NAME).isOffline());
        tom2.bringSiteOnline(REMOTE_SITE_NAME);
        ClusteredOfflineStatusTest.eventually(() -> !tom1.getOfflineStatus(REMOTE_SITE_NAME).isOffline());
        ClusteredOfflineStatusTest.eventually(() -> !tom2.getOfflineStatus(REMOTE_SITE_NAME).isOffline());
        tom2.takeSiteOffline(REMOTE_SITE_NAME);
        ClusteredOfflineStatusTest.eventually(() -> tom1.getOfflineStatus(REMOTE_SITE_NAME).isOffline());
        ClusteredOfflineStatusTest.eventually(() -> tom2.getOfflineStatus(REMOTE_SITE_NAME).isOffline());
    }
}

