/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.XSiteAdminOperations;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.testng.AssertJUnit;

public abstract class AbstractStateTransferTest
extends AbstractTwoSitesTest {
    void assertNoStateTransferInReceivingSite(String cacheName) {
        this.assertInSite("NYC-2", cacheName, this::assertNotReceivingStateForCache);
    }

    void assertNoStateTransferInSendingSite() {
        this.assertInSite("LON-1", cache -> AssertJUnit.assertTrue((boolean)this.isNotSendingStateForCache(cache)));
    }

    void assertEventuallyNoStateTransferInSendingSite() {
        this.assertEventuallyInSite("LON-1", this::isNotSendingStateForCache, 30L, TimeUnit.SECONDS);
    }

    protected void assertEventuallyStateTransferNotRunning() {
        this.assertEventuallyStateTransferNotRunning(this.cache("LON-1", 0));
    }

    protected void assertEventuallyStateTransferNotRunning(Cache<?, ?> cache) {
        AbstractStateTransferTest.eventually(() -> this.adminOperations(cache).getRunningStateTransfer().isEmpty(), 30L, TimeUnit.SECONDS);
    }

    int chunkSize() {
        return ((BackupConfiguration)this.cache("LON-1", 0).getCacheConfiguration().sites().allBackups().get(0)).stateTransfer().chunkSize();
    }

    protected void assertEventuallyNoStateTransferInReceivingSite(String cacheName) {
        this.assertEventuallyInSite("NYC-2", cacheName, this::isNotReceivingStateForCache, 30L, TimeUnit.SECONDS);
    }

    protected void startStateTransfer() {
        this.startStateTransfer(this.cache("LON-1", 0), "NYC-2");
    }

    protected void startStateTransfer(Cache<?, ?> cache, String toSite) {
        XSiteAdminOperations operations = TestingUtil.extractComponent(cache, XSiteAdminOperations.class);
        AssertJUnit.assertEquals((String)"ok", (String)operations.pushState(toSite));
    }

    protected void takeSiteOffline() {
        XSiteAdminOperations operations = TestingUtil.extractComponent(this.cache("LON-1", 0), XSiteAdminOperations.class);
        AssertJUnit.assertEquals((String)"ok", (String)operations.takeSiteOffline("NYC-2"));
    }

    protected void assertOffline() {
        XSiteAdminOperations operations = TestingUtil.extractComponent(this.cache("LON-1", 0), XSiteAdminOperations.class);
        AssertJUnit.assertEquals((String)"offline", (String)operations.siteStatus("NYC-2"));
    }

    protected void assertOnline(String localSite, String remoteSite) {
        XSiteAdminOperations operations = TestingUtil.extractComponent(this.cache(localSite, 0), XSiteAdminOperations.class);
        AssertJUnit.assertEquals((String)"online", (String)operations.siteStatus(remoteSite));
    }

    protected XSiteAdminOperations adminOperations() {
        return this.adminOperations(this.cache("LON-1", 0));
    }

    protected XSiteAdminOperations adminOperations(Cache<?, ?> cache) {
        return TestingUtil.extractComponent(cache, XSiteAdminOperations.class);
    }

    private void assertNotReceivingStateForCache(Cache<?, ?> cache) {
        CommitManager commitManager = TestingUtil.extractComponent(cache, CommitManager.class);
        AssertJUnit.assertFalse((boolean)commitManager.isTracking(Flag.PUT_FOR_STATE_TRANSFER));
        AssertJUnit.assertFalse((boolean)commitManager.isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER));
        AssertJUnit.assertTrue((boolean)commitManager.isEmpty());
    }

    private boolean isNotReceivingStateForCache(Cache<?, ?> cache) {
        CommitManager commitManager = TestingUtil.extractComponent(cache, CommitManager.class);
        return !commitManager.isTracking(Flag.PUT_FOR_STATE_TRANSFER) && !commitManager.isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER) && commitManager.isEmpty();
    }

    private boolean isNotSendingStateForCache(Cache<?, ?> cache) {
        return TestingUtil.extractComponent(cache, XSiteStateProvider.class).getCurrentStateSending().isEmpty();
    }
}

