/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.statetransfer.AbstractDelegatingXSiteStateTransferManager;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.testng.AssertJUnit;

class ControlledXSiteStateTransferManager
extends AbstractDelegatingXSiteStateTransferManager {
    private static final Log log = LogFactory.getLog(ControlledXSiteStateTransferManager.class);
    private static final long TIMEOUT_MILLIS = 20000L;
    @GuardedBy(value="this")
    private List<RemoteSiteRequest> sitesUp;

    private ControlledXSiteStateTransferManager(XSiteStateTransferManager delegate) {
        super(delegate);
    }

    public static ControlledXSiteStateTransferManager extract(Cache<?, ?> cache) {
        return AbstractDelegatingXSiteStateTransferManager.wrapCache(cache, ControlledXSiteStateTransferManager::new, ControlledXSiteStateTransferManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAutomaticStateTransferTo(ByteString remoteSite, boolean ignoreStatus) {
        ControlledXSiteStateTransferManager controlledXSiteStateTransferManager = this;
        synchronized (controlledXSiteStateTransferManager) {
            if (this.sitesUp != null) {
                log.tracef("Blocking automatic state transfer with sites %s", (Object)remoteSite);
                this.sitesUp.add(new RemoteSiteRequest(remoteSite, ignoreStatus));
                this.sitesUp.sort(null);
                this.notifyAll();
                return;
            }
        }
        super.startAutomaticStateTransferTo(remoteSite, ignoreStatus);
    }

    public synchronized void startBlockSiteUpEvent() {
        AssertJUnit.assertNull(this.sitesUp);
        this.sitesUp = new ArrayList<RemoteSiteRequest>(2);
    }

    public Runnable awaitAndStopBlockingAndAssert(String remoteSite) throws InterruptedException {
        return this.awaitAndStopBlockingAndAssert(Collections.singletonList(ByteString.fromString((String)remoteSite)));
    }

    public Runnable awaitAndStopBlockingAndAssert(String site1, String site2) throws InterruptedException {
        List<ByteString> list = Arrays.asList(ByteString.fromString((String)site1), ByteString.fromString((String)site2));
        list.sort(null);
        return this.awaitAndStopBlockingAndAssert(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable awaitAndStopBlockingAndAssert(List<ByteString> expectedSites) throws InterruptedException {
        List<RemoteSiteRequest> siteUpCopy;
        ControlledXSiteStateTransferManager controlledXSiteStateTransferManager = this;
        synchronized (controlledXSiteStateTransferManager) {
            AssertJUnit.assertNotNull(this.sitesUp);
            long endTime = System.currentTimeMillis() + 20000L;
            long waitTime = 20000L;
            while (this.sitesUp.size() < expectedSites.size() && waitTime > 0L) {
                this.wait(waitTime);
                waitTime = endTime - System.currentTimeMillis();
            }
            siteUpCopy = List.copyOf(this.sitesUp);
            this.sitesUp = null;
        }
        AssertJUnit.assertEquals(expectedSites, siteUpCopy.stream().map(r -> r.remoteSite).collect(Collectors.toList()));
        return () -> siteUpCopy.forEach(RemoteSiteRequest::run);
    }

    private class RemoteSiteRequest
    implements Comparable<RemoteSiteRequest> {
        final ByteString remoteSite;
        final boolean force;

        private RemoteSiteRequest(ByteString remoteSite, boolean force) {
            this.remoteSite = remoteSite;
            this.force = force;
        }

        void run() {
            ControlledXSiteStateTransferManager.super.startAutomaticStateTransferTo(this.remoteSite, this.force);
        }

        @Override
        public int compareTo(RemoteSiteRequest o) {
            return this.remoteSite.compareTo(o.remoteSite);
        }
    }
}

