/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsConfigurationBuilder;
import org.infinispan.configuration.global.StackBuilder;
import org.infinispan.configuration.global.StackConfiguration;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;

public class StackConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements StackBuilder<StackConfiguration> {
    private final AttributeSet attributes;
    private final JGroupsConfigurationBuilder jgroups;
    private EmbeddedJGroupsChannelConfigurator configurator;

    StackConfigurationBuilder(String name, JGroupsConfigurationBuilder jgroups) {
        super(jgroups.getGlobalConfig());
        this.jgroups = jgroups;
        this.attributes = StackConfiguration.attributeDefinitionSet();
        this.attributes.attribute(StackConfiguration.NAME).set((Object)name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public StackConfigurationBuilder extend(String extend) {
        this.attributes.attribute(StackConfiguration.EXTENDS).set((Object)extend);
        return this;
    }

    public StackConfigurationBuilder channelConfigurator(EmbeddedJGroupsChannelConfigurator configurator) {
        String extend = (String)this.attributes.attribute(StackConfiguration.EXTENDS).get();
        this.configurator = extend == null ? configurator : new EmbeddedJGroupsChannelConfigurator(configurator.getName(), configurator.getUncombinedProtocolStack(), configurator.getUncombinedRemoteSites(), extend);
        return this;
    }

    public StackConfiguration create() {
        return new StackConfiguration(this.attributes.protect(), this.configurator);
    }

    public StackConfigurationBuilder read(StackConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.configurator = template.configurator();
        return this;
    }

    @Override
    public JGroupsChannelConfigurator getConfigurator() {
        return this.configurator;
    }
}

