/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistryImpl;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.ModuleRepository;
import org.infinispan.util.logging.Log;

@Deprecated(forRemoval=true, since="9.4")
public abstract class AbstractComponentRegistry
implements Lifecycle {
    final ModuleRepository moduleRepository;
    final BasicComponentRegistry basicComponentRegistry;
    protected volatile ComponentStatus state = ComponentStatus.INSTANTIATED;

    AbstractComponentRegistry(ModuleRepository moduleRepository, boolean isGlobal, BasicComponentRegistry nextBasicComponentRegistry) {
        this.moduleRepository = moduleRepository;
        this.basicComponentRegistry = new BasicComponentRegistryImpl(moduleRepository, isGlobal, nextBasicComponentRegistry);
    }

    public ComponentStatus getStatus() {
        return this.state;
    }

    protected abstract ClassLoader getClassLoader();

    protected abstract Log getLog();

    public void wireDependencies(Object target) throws CacheConfigurationException {
        this.basicComponentRegistry.wireDependencies(target, true);
    }

    public void wireDependencies(Object target, boolean startDependencies) throws CacheConfigurationException {
        this.basicComponentRegistry.wireDependencies(target, startDependencies);
    }

    public final void registerComponent(Object component, Class<?> type) {
        this.registerComponent(component, type.getName(), type == component.getClass());
    }

    public final void registerComponent(Object component, String name) {
        this.registerComponent(component, name, name.equals(component.getClass().getName()));
    }

    public final void registerComponent(Object component, String name, boolean nameIsFQCN) {
        this.registerComponentInternal(component, name, nameIsFQCN);
    }

    protected final void registerNonVolatileComponent(Object component, String name) {
        this.registerComponentInternal(component, name, false);
    }

    protected void registerComponentInternal(Object component, String name, boolean nameIsFQCN) {
        ComponentRef<Object> ref = this.basicComponentRegistry.registerComponent(name, component, true);
        if (this.state == ComponentStatus.INITIALIZING || this.state == ComponentStatus.RUNNING) {
            ref.running();
        }
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass) {
        return this.getComponent(componentClass, componentClass.getName());
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass, String name) {
        return this.getComponent(componentClass, name);
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass, String name, boolean nameIsFQCN) {
        return this.getComponent(componentClass, name);
    }

    public <T> T getComponent(Class<T> type) {
        String className = type.getName();
        return this.getComponent(type, className);
    }

    public <T> T getComponent(String componentClassName) {
        return this.getComponent(componentClassName, componentClassName, true);
    }

    public <T> T getComponent(String componentClassName, String name) {
        return this.getComponent(componentClassName, name, false);
    }

    public <T> T getComponent(Class<T> componentClass, String name) {
        ComponentRef component = this.basicComponentRegistry.getComponent(name, componentClass);
        return component != null ? (T)component.wired() : null;
    }

    public <T> T getComponent(String componentClassName, String name, boolean nameIsFQCN) {
        return (T)this.getComponent(Object.class, name);
    }

    public <T> Optional<T> getOptionalComponent(Class<T> type) {
        return Optional.ofNullable(this.getComponent(type));
    }

    public void rewire() {
        this.basicComponentRegistry.rewire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AbstractComponentRegistry abstractComponentRegistry = this;
        synchronized (abstractComponentRegistry) {
            try {
                while (this.state == ComponentStatus.INITIALIZING) {
                    this.wait();
                }
                if (this.state != ComponentStatus.INSTANTIATED) {
                    return;
                }
                this.state = ComponentStatus.INITIALIZING;
            }
            catch (InterruptedException e) {
                throw new CacheException("Interrupted waiting for the component registry to start");
            }
        }
        try {
            this.preStart();
            this.internalStart();
            CompletionStage<Void> cs = this.delayStart();
            if (cs == null || CompletionStages.isCompletedSuccessfully(cs)) {
                this.updateStatusRunning();
                this.postStart();
            } else {
                cs.whenComplete((ignore, t) -> {
                    if (t != null) {
                        this.componentFailed((Throwable)t);
                    } else {
                        this.updateStatusRunning();
                        this.postStart();
                    }
                });
            }
        }
        catch (Throwable t2) {
            this.componentFailed(t2);
        }
    }

    private synchronized void updateStatusRunning() {
        if (this.state == ComponentStatus.INITIALIZING) {
            this.state = ComponentStatus.RUNNING;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void componentFailed(Throwable t) {
        AbstractComponentRegistry abstractComponentRegistry = this;
        synchronized (abstractComponentRegistry) {
            this.state = ComponentStatus.FAILED;
            this.notifyAll();
        }
        Log.CONFIG.startFailure(this.getName(), t);
        try {
            this.stop();
        }
        catch (Throwable t1) {
            t.addSuppressed(t1);
        }
        this.handleLifecycleTransitionFailure(t);
    }

    protected abstract String getName();

    protected abstract void preStart();

    protected abstract void postStart();

    protected abstract CompletionStage<Void> delayStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        boolean failed;
        AbstractComponentRegistry abstractComponentRegistry = this;
        synchronized (abstractComponentRegistry) {
            try {
                while (this.state == ComponentStatus.STOPPING) {
                    this.wait();
                }
                if (!this.state.stopAllowed()) {
                    this.getLog().debugf("Ignoring call to stop() as current state is %s", (Object)this.state);
                    return;
                }
                failed = this.state == ComponentStatus.FAILED;
                this.state = ComponentStatus.STOPPING;
            }
            catch (InterruptedException e) {
                throw new CacheException("Interrupted waiting for the component registry to stop");
            }
        }
        this.preStop();
        try {
            this.internalStop();
            this.postStop();
        }
        catch (Throwable t) {
            if (failed) {
                this.getLog().failedToCallStopAfterFailure(t);
            } else {
                this.handleLifecycleTransitionFailure(t);
            }
        }
        finally {
            abstractComponentRegistry = this;
            synchronized (abstractComponentRegistry) {
                this.state = ComponentStatus.TERMINATED;
                this.notifyAll();
            }
        }
    }

    protected abstract void postStop();

    protected abstract void preStop();

    private void handleLifecycleTransitionFailure(Throwable t) {
        if (t.getCause() != null && t.getCause() instanceof CacheConfigurationException) {
            throw (CacheConfigurationException)t.getCause();
        }
        if (t.getCause() != null && t.getCause() instanceof InvocationTargetException && t.getCause().getCause() != null && t.getCause().getCause() instanceof CacheConfigurationException) {
            throw (CacheConfigurationException)t.getCause().getCause();
        }
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void internalStart() throws CacheException, IllegalArgumentException {
        Collection<ComponentRef<?>> components = this.basicComponentRegistry.getRegisteredComponents();
        for (ComponentRef<?> component : components) {
            component.running();
        }
        this.addShutdownHook();
    }

    protected void addShutdownHook() {
    }

    protected void removeShutdownHook() {
    }

    private void internalStop() {
        this.removeShutdownHook();
        this.basicComponentRegistry.stop();
    }

    public abstract TimeService getTimeService();
}

