package org.infinispan.manager;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.processing.Generated;

import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.MBeanMetadata.AttributeMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationParameterMetadata;
import org.infinispan.factories.impl.Scopes;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.lifecycle.ModuleLifecycle;

/**
 * @api.private 
 */
@Generated(value = "org.infinispan.component.processor.Generator", date = "2025-08-14T18:06:03.920145215Z")
public final class CorePackageImpl {
   public static void registerMetadata(ModuleMetadataBuilder.ModuleBuilder builder) {
//start org.infinispan.manager.DefaultCacheManager
      builder.registerComponentAccessor("org.infinispan.manager.DefaultCacheManager",
         Collections.emptyList(),
         new ComponentAccessor<DefaultCacheManager>("org.infinispan.manager.DefaultCacheManager",
            0, true, null,
            Collections.emptyList()));

      builder.registerMBeanMetadata("org.infinispan.manager.DefaultCacheManager",
         MBeanMetadata.of("CacheManager", "Component that acts as a manager, factory and container for caches in the system.", null, Scopes.GLOBAL,
            new AttributeMetadata("cacheManagerStatus", "The status of the cache manager instance.", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("clusterMembers", "List of members in the cluster", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("clusterMembersPhysicalAddresses", "List of members in the cluster", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("clusterName", "Cluster name", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("clusterSize", "Size of the cluster in number of nodes", false, true, "int", false, (java.util.function.Function<org.infinispan.manager.DefaultCacheManager, ?>) org.infinispan.manager.DefaultCacheManager::getClusterSize, null, false),
            new AttributeMetadata("coordinator", "Indicates whether this node is coordinator", false, true, "boolean", true, null, null, false),
            new AttributeMetadata("coordinatorAddress", "The logical address of the cluster's coordinator", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("createdCacheCount", "The total number of created caches, including the default cache.", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("definedCacheConfigurationNames", "The defined cache configuration names.", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("definedCacheCount", "The total number of defined cache configurations.", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("definedCacheNames", "The defined cache names and their statuses.  The default cache is not included in this representation.", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("globalConfigurationAsProperties", "Global configuration properties", false, true, "java.util.Properties", false, null, null, false),
            new AttributeMetadata("name", "The name of this cache manager", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("nodeAddress", "The network address associated with this instance", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("numberOfCacheConfigurations", "The total number of defined cache configurations.", false, true, "int", false, (java.util.function.Function<org.infinispan.manager.DefaultCacheManager, ?>) org.infinispan.manager.DefaultCacheManager::getNumberOfCacheConfigurations, null, false),
            new AttributeMetadata("numberOfCreatedCaches", "The total number of created caches, including the default cache.", false, true, "long", false, (java.util.function.Function<org.infinispan.manager.DefaultCacheManager, ?>) org.infinispan.manager.DefaultCacheManager::getNumberOfCreatedCaches, null, false),
            new AttributeMetadata("numberOfRunningCaches", "The total number of running caches, including the default cache.", false, true, "long", false, (java.util.function.Function<org.infinispan.manager.DefaultCacheManager, ?>) org.infinispan.manager.DefaultCacheManager::getNumberOfRunningCaches, null, false),
            new AttributeMetadata("physicalAddresses", "The physical network addresses associated with this instance", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("relayNode", "Indicates whether this node is a relay node", false, true, "boolean", true, null, null, false),
            new AttributeMetadata("relayNodesAddress", "Lists relay nodes in the local site", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("runningCacheCount", "The total number of running caches, including the default cache.", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("site", "Returns the local site name", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("siteView", "Lists all online sites", false, true, "java.lang.String", false, null, null, false),
            new AttributeMetadata("version", "Returns the version of Infinispan", false, true, "java.lang.String", false, null, null, false),
            new OperationMetadata("startCache", "", "Starts the default cache associated with this cache manager", "void"
            ),
            new OperationMetadata("startCache", "startCache", "Starts a named cache from this cache manager", "void",
               new OperationParameterMetadata("cacheName", "java.lang.String", "Name of cache to start")
            )
      ));

//start org.infinispan.manager.EmbeddedCacheManager
      builder.registerComponentAccessor("org.infinispan.manager.EmbeddedCacheManager",
         Collections.emptyList(),
         new ComponentAccessor<EmbeddedCacheManager>("org.infinispan.manager.EmbeddedCacheManager",
            0, true, null,
            Collections.emptyList()));

//end
   }
}
