/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.util.logging.Log;

public class ConfigurationManager {
    private final GlobalConfiguration globalConfiguration;
    private final Map<String, Configuration> namedConfiguration;
    private final Map<String, String> aliases;

    public ConfigurationManager(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
        this.namedConfiguration = new ConcurrentHashMap<String, Configuration>();
        this.aliases = new ConcurrentHashMap<String, String>();
    }

    public ConfigurationManager(ConfigurationBuilderHolder holder) {
        this(holder.getGlobalConfigurationBuilder().build());
        holder.getNamedConfigurationBuilders().forEach((name, builder) -> this.putConfiguration((String)name, builder.build(this.globalConfiguration)));
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public Configuration getConfiguration(String cacheName, boolean includeWildcards) {
        if (includeWildcards) {
            return this.findConfiguration(cacheName);
        }
        return this.namedConfiguration.get(cacheName);
    }

    public Configuration getConfiguration(String cacheName) {
        Configuration configuration = this.findConfiguration(cacheName);
        if (configuration != null) {
            return configuration;
        }
        throw Log.CONFIG.noSuchCacheConfiguration(cacheName);
    }

    private Configuration findConfiguration(String name) {
        if (this.namedConfiguration.containsKey(name)) {
            return this.namedConfiguration.get(name);
        }
        Configuration match = null;
        for (Map.Entry<String, Configuration> c : this.namedConfiguration.entrySet()) {
            String key = c.getKey();
            if (!GlobUtils.isGlob((String)key) || !name.matches(GlobUtils.globToRegex((String)key))) continue;
            if (match == null) {
                match = c.getValue();
                if (!match.isTemplate()) continue;
                ConfigurationBuilder builder = new ConfigurationBuilder().read(match).template(false);
                match = builder.build();
                continue;
            }
            throw Log.CONFIG.configurationNameMatchesMultipleWildcards(name);
        }
        return match;
    }

    public Configuration putConfiguration(String cacheName, Configuration configuration) {
        this.addAliases(cacheName, configuration.aliases());
        this.namedConfiguration.put(cacheName, configuration);
        configuration.attributes().attribute(Configuration.ALIASES).addListener((AttributeListener)new AliasListener(cacheName));
        return configuration;
    }

    public Configuration putConfiguration(String cacheName, ConfigurationBuilder builder) {
        return this.putConfiguration(cacheName, builder.build(this.globalConfiguration));
    }

    public void removeConfiguration(String cacheName) {
        Configuration removed = this.namedConfiguration.remove(cacheName);
        if (removed != null) {
            removed.attributes().attribute(Configuration.ALIASES).removeListener(f -> f.getClass() == AliasListener.class);
            this.removeAliases(removed.aliases());
        }
    }

    public Collection<String> getDefinedCaches() {
        return this.namedConfiguration.entrySet().stream().filter(entry -> !((Configuration)((Object)((Object)entry.getValue()))).isTemplate()).map(Map.Entry::getKey).toList();
    }

    public Collection<String> getAliases() {
        return this.aliases.keySet();
    }

    public Collection<String> getDefinedConfigurations() {
        return Collections.unmodifiableCollection(this.namedConfiguration.keySet());
    }

    public ConfigurationBuilderHolder toBuilderHolder() {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.getGlobalConfigurationBuilder().read(this.globalConfiguration);
        for (Map.Entry<String, Configuration> entry : this.namedConfiguration.entrySet()) {
            holder.newConfigurationBuilder(entry.getKey()).read(entry.getValue(), Combine.DEFAULT);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAliases(String cacheName, Collection<String> aliases) {
        Map<String, String> map = this.aliases;
        synchronized (map) {
            for (String alias : aliases) {
                if (this.namedConfiguration.containsKey(alias) || cacheName.equals(alias)) {
                    throw Log.CONFIG.duplicateCacheName(alias);
                }
                if (!this.aliases.containsKey(alias)) continue;
                throw Log.CONFIG.duplicateAliasName(alias, this.aliases.get(alias));
            }
            for (String alias : aliases) {
                this.aliases.put(alias, cacheName);
            }
        }
    }

    private void removeAliases(Collection<String> aliases) {
        for (String alias : aliases) {
            this.aliases.remove(alias);
        }
    }

    public String selectCache(String cacheName) {
        return this.aliases.getOrDefault(cacheName, cacheName);
    }

    class AliasListener
    implements AttributeListener<List<String>> {
        private final String cacheName;

        AliasListener(String cacheName) {
            this.cacheName = cacheName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attributeChanged(Attribute<List<String>> attribute, List<String> oldValues) {
            Map<String, String> map = ConfigurationManager.this.aliases;
            synchronized (map) {
                ArrayList<String> newValues = new ArrayList<String>((Collection)attribute.get());
                newValues.removeAll(oldValues);
                ConfigurationManager.this.addAliases(this.cacheName, newValues);
                ArrayList<String> removedValues = new ArrayList<String>(oldValues);
                removedValues.removeAll((Collection)attribute.get());
                ConfigurationManager.this.removeAliases(removedValues);
            }
        }
    }
}

