/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.distribution.Collector;
import org.infinispan.interceptors.distribution.PrimaryOwnerOnlyCollector;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class CommandAckCollector {
    private static final Log log = LogFactory.getLog(CommandAckCollector.class);
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    ScheduledExecutorService timeoutExecutor;
    @Inject
    Configuration configuration;
    private final ConcurrentHashMap<Long, BaseCollector<?>> collectorMap = new ConcurrentHashMap(64);
    private long timeoutNanoSeconds;

    @Start
    public void start() {
        this.timeoutNanoSeconds = TimeUnit.MILLISECONDS.toNanos(this.configuration.clustering().remoteTimeout());
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener((a, ignored) -> {
            this.timeoutNanoSeconds = TimeUnit.MILLISECONDS.toNanos(((TimeQuantity)a.get()).longValue());
        });
    }

    public <T> Collector<T> create(long id, Collection<Address> backupOwners, int topologyId) {
        if (backupOwners.isEmpty()) {
            return new PrimaryOwnerOnlyCollector();
        }
        SingleKeyCollector collector = new SingleKeyCollector(id, backupOwners, topologyId);
        BaseCollector prev = this.collectorMap.put(id, collector);
        assert (prev == null || prev.topologyId < topologyId) : String.format("replaced old collector '%s' by '%s'", prev, collector);
        if (log.isTraceEnabled()) {
            log.tracef("Created new collector for %s. BackupOwners=%s", id, backupOwners);
        }
        return collector;
    }

    public <T> Collector<T> createSegmentBasedCollector(long id, Map<Address, Collection<Integer>> backups, int topologyId) {
        if (backups.isEmpty()) {
            return new PrimaryOwnerOnlyCollector();
        }
        SegmentBasedCollector collector = new SegmentBasedCollector(id, backups, topologyId);
        BaseCollector prev = this.collectorMap.put(id, collector);
        assert (prev == null || prev.topologyId < topologyId) : String.format("replaced old collector '%s' by '%s'", prev, collector);
        if (log.isTraceEnabled()) {
            log.tracef("Created new collector for %s. BackupSegments=%s", id, backups);
        }
        return collector;
    }

    public void backupAck(long id, Address from, int segment, int topologyId) {
        BaseCollector<?> collector = this.collectorMap.get(id);
        if (collector != null) {
            collector.backupAck(from, segment, topologyId);
        }
    }

    public void completeExceptionally(long id, Throwable throwable, int topologyId) {
        BaseCollector<?> ackTarget = this.collectorMap.get(id);
        if (ackTarget != null) {
            ackTarget.completeExceptionally(throwable, topologyId);
        }
    }

    public List<Long> getPendingCommands() {
        return new ArrayList<Long>(this.collectorMap.keySet());
    }

    public boolean hasPendingBackupAcks(long id) {
        BaseCollector<?> ackTarget = this.collectorMap.get(id);
        return ackTarget != null && ackTarget.hasPendingBackupAcks();
    }

    public void onMembersChange(Collection<Address> members) {
        HashSet<Address> currentMembers = new HashSet<Address>(members);
        for (BaseCollector<?> ackTarget : this.collectorMap.values()) {
            ackTarget.onMembersChange(currentMembers);
        }
    }

    private class SingleKeyCollector<T>
    extends BaseCollector<T> {
        @GuardedBy(value="this")
        final Collection<Address> backupOwners;

        private SingleKeyCollector(long id, Collection<Address> backupOwners, int topologyId) {
            super(id, topologyId);
            this.backupOwners = new HashSet<Address>(backupOwners);
        }

        @Override
        synchronized boolean hasPendingBackupAcks() {
            if (log.isTraceEnabled()) {
                log.tracef("Pending backup acks: %s", this.backupOwners);
            }
            return !this.backupOwners.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onMembersChange(Collection<Address> members) {
            boolean empty;
            SingleKeyCollector singleKeyCollector = this;
            synchronized (singleKeyCollector) {
                empty = this.backupOwners.retainAll(members) && this.backupOwners.isEmpty();
            }
            if (empty && this.primaryResultReceived) {
                if (log.isTraceEnabled()) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.markReady();
            }
        }

        @Override
        public void primaryResult(T result, boolean success) {
            this.primaryResult = result;
            this.primaryResultReceived = true;
            if (!success || !this.hasPendingBackupAcks()) {
                this.markReady();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void backupAck(Address from, int segment, int topologyId) {
            boolean empty;
            assert (segment >= 0);
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] Backup ACK. Address=%s, TopologyId=%s (expected=%s)", new Object[]{this.id, from, topologyId, this.topologyId});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            SingleKeyCollector singleKeyCollector = this;
            synchronized (singleKeyCollector) {
                empty = this.backupOwners.remove(from) && this.backupOwners.isEmpty();
            }
            if (empty && this.primaryResultReceived) {
                this.markReady();
            }
        }

        void markReady() {
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] Ready!", this.id);
            }
            this.future.complete(this.primaryResult);
        }

        @Override
        protected synchronized String getAddress() {
            return this.backupOwners.toString();
        }

        public synchronized String toString() {
            return "SingleKeyCollector{id=" + this.id + ", topologyId=" + this.topologyId + ", primaryResult=" + String.valueOf(this.primaryResult) + ", primaryResultReceived=" + this.primaryResultReceived + ", backupOwners=" + String.valueOf(this.backupOwners) + "}";
        }
    }

    private abstract class BaseCollector<T>
    implements Collector<T>,
    Callable<Void>,
    BiConsumer<T, Throwable> {
        final long id;
        final int topologyId;
        final ScheduledFuture<?> timeoutTask;
        final CompletableFuture<T> future;
        final CompletableFuture<T> exposedFuture;
        volatile T primaryResult;
        volatile boolean primaryResultReceived;

        BaseCollector(long id, int topologyId) {
            this.topologyId = topologyId;
            this.id = id;
            this.timeoutTask = CommandAckCollector.this.timeoutExecutor.schedule(this, CommandAckCollector.this.timeoutNanoSeconds, TimeUnit.NANOSECONDS);
            this.future = new CompletableFuture();
            this.exposedFuture = this.future.whenComplete((BiConsumer)this);
        }

        @Override
        public final synchronized Void call() {
            this.future.completeExceptionally(log.timeoutWaitingForAcks(Util.prettyPrintTime((long)CommandAckCollector.this.timeoutNanoSeconds, (TimeUnit)TimeUnit.NANOSECONDS), this.getAddress(), this.id, this.topologyId));
            return null;
        }

        protected abstract String getAddress();

        @Override
        public final CompletableFuture<T> getFuture() {
            return this.exposedFuture;
        }

        @Override
        public void primaryException(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        final void completeExceptionally(Throwable throwable, int topologyId) {
            if (log.isTraceEnabled()) {
                log.tracef(throwable, "[Collector#%s] completed exceptionally. TopologyId=%s (expected=%s)", this.id, topologyId, this.topologyId);
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            this.future.completeExceptionally(throwable);
        }

        final boolean isWrongTopologyOrIsDone(int topologyId) {
            return this.topologyId != topologyId || this.future.isDone();
        }

        @Override
        public final void accept(T t, Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] Collector completed with ret=%s, throw=%s", this.id, t, throwable);
            }
            boolean removed = CommandAckCollector.this.collectorMap.remove(this.id, this);
            assert (removed);
            this.timeoutTask.cancel(false);
        }

        abstract boolean hasPendingBackupAcks();

        abstract void onMembersChange(Collection<Address> var1);

        abstract void backupAck(Address var1, int var2, int var3);
    }

    private class SegmentBasedCollector<T>
    extends BaseCollector<T> {
        @GuardedBy(value="this")
        private final Map<Address, Collection<Integer>> backups;

        SegmentBasedCollector(long id, Map<Address, Collection<Integer>> backups, int topologyId) {
            super(id, topologyId);
            this.backups = backups;
        }

        @Override
        public synchronized boolean hasPendingBackupAcks() {
            return !this.backups.isEmpty();
        }

        @Override
        public synchronized void onMembersChange(Collection<Address> members) {
            if (this.backups.keySet().retainAll(members)) {
                if (log.isTraceEnabled()) {
                    log.tracef("[Collector#%s] Some backups left the cluster.", this.id);
                }
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void primaryResult(T result, boolean success) {
            this.primaryResult = result;
            this.primaryResultReceived = true;
            SegmentBasedCollector segmentBasedCollector = this;
            synchronized (segmentBasedCollector) {
                this.checkCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void backupAck(Address from, int segment, int topologyId) {
            assert (segment >= 0);
            if (log.isTraceEnabled()) {
                log.tracef("[Collector#%s] PutMap Backup ACK. Address=%s. TopologyId=%s (expected=%s). Segment=%s", new Object[]{this.id, from, topologyId, this.topologyId, segment});
            }
            if (this.isWrongTopologyOrIsDone(topologyId)) {
                return;
            }
            SegmentBasedCollector segmentBasedCollector = this;
            synchronized (segmentBasedCollector) {
                Collection pendingSegments = this.backups.getOrDefault(from, Collections.emptyList());
                if (pendingSegments.remove(segment) && pendingSegments.isEmpty()) {
                    this.backups.remove(from);
                    this.checkCompleted();
                }
            }
        }

        @GuardedBy(value="this")
        private void checkCompleted() {
            if (this.primaryResultReceived && this.backups.isEmpty()) {
                if (log.isTraceEnabled()) {
                    log.tracef("[Collector#%s] Ready! Return value=%ss.", this.id, this.primaryResult);
                }
                this.future.complete(this.primaryResult);
            }
        }

        @Override
        protected synchronized String getAddress() {
            return this.backups.keySet().toString();
        }

        public synchronized String toString() {
            return "SegmentBasedCollector{id=" + this.id + ", topologyId=" + this.topologyId + ", primaryResult=" + String.valueOf(this.primaryResult) + ", primaryResultReceived=" + this.primaryResultReceived + ", backups=" + String.valueOf(this.backups) + "}";
        }
    }
}

