/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvalidateL1Command
extends InvalidateCommand {
    public static final int COMMAND_ID = 7;
    private static final Log log = LogFactory.getLog(InvalidateL1Command.class);
    private DistributionManager dm;
    private DataContainer dataContainer;
    private Configuration config;
    private boolean forRehash;
    private Address writeOrigin;

    public InvalidateL1Command() {
        this.writeOrigin = null;
    }

    public InvalidateL1Command(boolean forRehash, DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Object ... keys) {
        super(notifier, keys);
        this.writeOrigin = null;
        this.dm = dm;
        this.forRehash = forRehash;
        this.dataContainer = dc;
        this.config = config;
    }

    public InvalidateL1Command(boolean forRehash, DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Collection<Object> keys) {
        this(null, forRehash, dc, config, dm, notifier, keys);
    }

    public InvalidateL1Command(Address writeOrigin, boolean forRehash, DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Collection<Object> keys) {
        super(notifier, keys);
        this.writeOrigin = writeOrigin;
        this.dm = dm;
        this.forRehash = forRehash;
        this.dataContainer = dc;
        this.config = config;
    }

    @Override
    public byte getCommandId() {
        return 7;
    }

    public void init(Configuration config, DistributionManager dm, CacheNotifier n, DataContainer dc) {
        super.init(n);
        this.dm = dm;
        this.config = config;
        this.dataContainer = dc;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (log.isTraceEnabled()) {
            log.tracef("Preparing to invalidate keys %s", Arrays.asList(this.keys));
        }
        for (Object k : this.getKeys()) {
            InternalCacheEntry ice = this.dataContainer.get(k);
            if (ice == null) continue;
            DataLocality locality = this.dm.getLocality(k);
            if (!this.forRehash) {
                while (locality.isUncertain() && this.dm.isRehashInProgress()) {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
                    locality = this.dm.getLocality(k);
                }
            }
            if (locality.isLocal()) continue;
            if (this.forRehash && this.config.isL1OnRehash()) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Not removing, instead entry will be stored in L1");
                continue;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Invalidating key %s.", k);
            }
            this.invalidate(ctx, k);
        }
        return null;
    }

    public void setKeys(Object[] keys) {
        this.keys = keys;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        if (ctx.isOriginLocal() || this.forRehash) {
            return true;
        }
        for (Object k : this.getKeys()) {
            DataLocality locality = this.dm.getLocality(k);
            if (locality.isLocal() && !locality.isUncertain()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvalidateL1Command that = (InvalidateL1Command)o;
        return this.forRehash == that.forRehash;
    }

    @Override
    public Object[] getParameters() {
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{this.forRehash, this.writeOrigin};
        }
        if (this.keys.length == 1) {
            return new Object[]{this.forRehash, this.writeOrigin, 1, this.keys[0]};
        }
        Object[] retval = new Object[this.keys.length + 3];
        retval[0] = this.forRehash;
        retval[1] = this.writeOrigin;
        retval[2] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 3, this.keys.length);
        return retval;
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.forRehash = (Boolean)args[0];
        this.writeOrigin = (Address)args[1];
        int size = (Integer)args[2];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[3];
        } else if (size > 0) {
            System.arraycopy(args, 3, this.keys, 0, size);
        }
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateL1Command(ctx, this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.forRehash ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "num keys=" + (this.keys == null ? 0 : this.keys.length) + ", forRehash=" + this.forRehash + ", origin=" + this.writeOrigin + '}';
    }

    public boolean isCausedByALocalWrite(Address address) {
        return this.writeOrigin != null && this.writeOrigin.equals(address);
    }
}

