/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

@Immutable
public class SingletonListExternalizer
extends AbstractExternalizer<List<?>> {
    @Override
    public void writeObject(ObjectOutput output, List list) throws IOException {
        output.writeObject(list.get(0));
    }

    @Override
    public List<?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return Collections.singletonList(input.readObject());
    }

    @Override
    public Integer getId() {
        return 4;
    }

    @Override
    public Set<Class<? extends List<?>>> getTypeClasses() {
        return Util.asSet(Util.loadClass("java.util.Collections$SingletonList", null));
    }
}

