/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredRepeatableReadEntry
extends RepeatableReadEntry {
    private static final Log log = LogFactory.getLog(ClusteredRepeatableReadEntry.class);
    private EntryVersion version;

    public ClusteredRepeatableReadEntry(Object key, Object value, EntryVersion version, long lifespan) {
        super(key, value, version, lifespan);
        this.version = version;
    }

    public boolean performWriteSkewCheck(DataContainer container, TxInvocationContext ctx) {
        EntryVersion prevVersion;
        InternalCacheEntry ice = container.get(this.key);
        if (ice == null) {
            log.tracef("No entry for key %s found in data container", this.key);
            prevVersion = ctx.getCacheTransaction().getLookedUpRemoteVersion(this.key);
            if (prevVersion == null) {
                log.tracef("No looked up remote version for key %s found in context", this.key);
                return this.version == null;
            }
        } else {
            prevVersion = ice.getVersion();
            if (prevVersion == null) {
                throw new IllegalStateException("Entries cannot have null versions!");
            }
        }
        if (this.version == null) {
            return true;
        }
        log.tracef("Comparing versions %s and %s for key %s: %s", new Object[]{prevVersion, this.version, this.key, prevVersion.compareTo(this.version)});
        return InequalVersionComparisonResult.AFTER != prevVersion.compareTo(this.version);
    }

    @Override
    public EntryVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.version = version;
    }
}

