/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Transaction;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class InvalidationInterceptor
extends BaseRpcInterceptor {
    private final AtomicLong invalidations = new AtomicLong(0L);
    private CommandsFactory commandsFactory;
    private boolean statisticsEnabled;
    private static final Log log = LogFactory.getLog(InvalidationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Start
    private void initTxMap() {
        this.setStatisticsEnabled(this.cacheConfiguration.jmxStatistics().enabled());
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.isPutForExternalRead(command)) {
            return this.handleInvalidate(ctx, command, command.getKey());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!this.isLocalModeForced(command) && ctx.isOriginLocal()) {
            this.rpcManager.broadcastRpcCommand(command, this.defaultSynchronous);
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object[] keys = command.getMap() == null ? null : command.getMap().keySet().toArray();
        return this.handleInvalidate(ctx, command, keys);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        log.tracef("Entering InvalidationInterceptor's prepare phase.  Ctx flags are empty", new Object[0]);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            List<WriteCommand> mods = Arrays.asList(command.getModifications());
            Transaction runningTransaction = ctx.getTransaction();
            if (runningTransaction == null) {
                throw new IllegalStateException("we must have an associated transaction");
            }
            this.broadcastInvalidateForPrepare(mods, runningTransaction, ctx);
        } else {
            log.tracef("Nothing to invalidate - no modifications in the transaction.", new Object[0]);
        }
        return retval;
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal()) {
            boolean sync = !command.isUnlock();
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(this.rpcManager.getTransport().getMembers());
            this.rpcManager.broadcastRpcCommand(command, sync, false);
        }
        return retVal;
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful() && !ctx.isInTxScope() && keys != null && keys.length != 0 && !this.isLocalModeForced(command)) {
            this.invalidateAcrossCluster(this.isSynchronous(command), keys);
        }
        return retval;
    }

    private void broadcastInvalidateForPrepare(List<WriteCommand> modifications, Transaction tx, InvocationContext ctx) throws Throwable {
        if (ctx.isInTxScope()) {
            if (modifications == null || modifications.isEmpty()) {
                return;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                log.debug("Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else if (filterVisitor.containsLocalModeFlag) {
                log.debug("Modification list contains a local mode flagged operation.  Not invalidating.");
            } else {
                try {
                    this.invalidateAcrossCluster(this.defaultSynchronous, filterVisitor.result.toArray());
                }
                catch (Throwable t) {
                    log.warn("Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException("Unable to broadcast invalidation messages", t);
                }
            }
        }
    }

    protected void invalidateAcrossCluster(boolean synchronous, Object[] keys) throws Throwable {
        this.incrementInvalidations();
        InvalidateCommand command = this.commandsFactory.buildInvalidateCommand(InfinispanCollections.<Flag>emptySet(), keys);
        if (log.isDebugEnabled()) {
            log.debug("Cache [" + this.rpcManager.getTransport().getAddress() + "] replicating " + command);
        }
        this.rpcManager.broadcastRpcCommand(command, synchronous);
    }

    private void incrementInvalidations() {
        if (this.statisticsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    private boolean isPutForExternalRead(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            log.trace("Put for external read called.  Suppressing clustered invalidation.");
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    @ManagedAttribute(displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Number of invalidations", displayName="Number of invalidations", measurementType=MeasurementType.TRENDSUP)
    public long getInvalidations() {
        return this.invalidations.get();
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        public boolean containsPutForExternalRead = false;
        public boolean containsLocalModeFlag = false;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        private void processCommand(FlagAffectedCommand command) {
            this.containsLocalModeFlag = this.containsLocalModeFlag || command.getFlags() != null && command.getFlags().contains((Object)Flag.CACHE_MODE_LOCAL);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.processCommand(command);
            this.containsPutForExternalRead = this.containsPutForExternalRead || command.getFlags() != null && command.getFlags().contains((Object)Flag.PUT_FOR_EXTERNAL_READ);
            this.result.add(command.getKey());
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.processCommand(command);
            this.result.add(command.getKey());
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.processCommand(command);
            this.result.addAll(command.getAffectedKeys());
            return null;
        }
    }
}

