/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class InboundInvocationHandlerImpl
implements InboundInvocationHandler {
    private GlobalComponentRegistry gcr;
    private static final Log log = LogFactory.getLog(InboundInvocationHandlerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private GlobalConfiguration globalConfiguration;
    private Transport transport;
    private CancellationService cancelService;

    @Inject
    public void inject(GlobalComponentRegistry gcr, Transport transport, GlobalConfiguration globalConfiguration, CancellationService cancelService) {
        this.gcr = gcr;
        this.transport = transport;
        this.globalConfiguration = globalConfiguration;
        this.cancelService = cancelService;
    }

    @Override
    public Response handle(CacheRpcCommand cmd, Address origin) throws Throwable {
        cmd.setOrigin(origin);
        String cacheName = cmd.getCacheName();
        ComponentRegistry cr = this.gcr.getNamedComponentRegistry(cacheName);
        if (cr == null) {
            if (!this.globalConfiguration.transport().strictPeerToPeer()) {
                if (trace) {
                    log.tracef("Strict peer to peer off, so silently ignoring that %s cache is not defined", cacheName);
                }
            } else {
                log.namedCacheDoesNotExist(cacheName);
            }
            return CacheNotFoundResponse.INSTANCE;
        }
        return this.handleWithWaitForBlocks(cmd, cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response handleInternal(CacheRpcCommand cmd, ComponentRegistry cr) throws Throwable {
        CommandsFactory commandsFactory = cr.getCommandsFactory();
        commandsFactory.initializeReplicableCommand(cmd, true);
        try {
            if (trace) {
                log.tracef("Calling perform() on %s", cmd);
            }
            ResponseGenerator respGen = cr.getResponseGenerator();
            if (cmd instanceof CancellableCommand) {
                this.cancelService.register(Thread.currentThread(), ((CancellableCommand)cmd).getUUID());
            }
            Object retval = cmd.perform(null);
            Response response = respGen.getResponse(cmd, retval);
            log.tracef("About to send back response %s for command %s", response, cmd);
            Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            log.error("Exception executing command", e);
            ExceptionResponse exceptionResponse = new ExceptionResponse(e);
            return exceptionResponse;
        }
        finally {
            if (cmd instanceof CancellableCommand) {
                this.cancelService.unregister(((CancellableCommand)cmd).getUUID());
            }
        }
    }

    private Response handleWithWaitForBlocks(CacheRpcCommand cmd, ComponentRegistry cr) throws Throwable {
        StateTransferManager stm = cr.getStateTransferManager();
        if (!stm.isJoinComplete()) {
            return null;
        }
        Response resp = this.handleInternal(cmd, cr);
        if (trace && resp != null && !resp.isValid()) {
            log.tracef("Unable to execute command, got invalid response %s", resp);
        }
        return resp;
    }
}

