/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;

public class JGroupsBackupResponse
implements BackupResponse {
    private static Log log = LogFactory.getLog(JGroupsBackupResponse.class);
    private final Map<XSiteBackup, Future<Object>> syncBackupCalls;
    private Map<String, Throwable> errors;
    private Set<String> communicationErrors;
    private long sendTimeNanos;

    public JGroupsBackupResponse(Map<XSiteBackup, Future<Object>> syncBackupCalls) {
        this.syncBackupCalls = syncBackupCalls;
        this.sendTimeNanos = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForBackupToFinish() throws Exception {
        long deductFromTimeout = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.sendTimeNanos);
        this.errors = new HashMap<String, Throwable>(this.syncBackupCalls.size());
        long elapsedTime = 0L;
        for (Map.Entry<XSiteBackup, Future<Object>> entry : this.syncBackupCalls.entrySet()) {
            long timeout = entry.getKey().getTimeout();
            String siteName = entry.getKey().getSiteName();
            if (timeout > 0L) {
                timeout -= deductFromTimeout;
                if ((timeout -= elapsedTime) <= 0L && !entry.getValue().isDone()) {
                    log.tracef("Timeout period %ld exhausted with site %s", entry.getKey().getTimeout(), siteName);
                    this.errors.put(siteName, this.newTimeoutException(entry, entry.getKey().getTimeout()));
                    this.addCommunicationError(siteName);
                    continue;
                }
            }
            long startNanos = System.nanoTime();
            Object value = null;
            try {
                value = entry.getValue().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                this.errors.put(siteName, this.newTimeoutException(entry, entry.getKey().getTimeout()));
                this.addCommunicationError(siteName);
            }
            catch (ExecutionException ue) {
                log.tracef(ue.getCause(), "Communication error with site %s", siteName);
                this.errors.put(siteName, ue.getCause());
                this.addCommunicationError(siteName);
            }
            finally {
                elapsedTime += TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            }
            if (value instanceof ExceptionResponse) {
                Exception remoteException = ((ExceptionResponse)value).getException();
                log.tracef(remoteException, "Got error backup response from site %s", siteName);
                this.errors.put(siteName, remoteException);
                continue;
            }
            log.tracef("Received response from site %s: %s", siteName, value);
        }
    }

    private void addCommunicationError(String siteName) {
        if (this.communicationErrors == null) {
            this.communicationErrors = new HashSet<String>(1);
        }
        this.communicationErrors.add(siteName);
    }

    @Override
    public Set<String> getCommunicationErrors() {
        return this.communicationErrors == null ? InfinispanCollections.emptySet() : this.communicationErrors;
    }

    @Override
    public long getSendTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.sendTimeNanos);
    }

    @Override
    public Map<String, Throwable> getFailedBackups() {
        return this.errors;
    }

    private org.infinispan.util.concurrent.TimeoutException newTimeoutException(Map.Entry<XSiteBackup, Future<Object>> entry, long timeout) {
        return new org.infinispan.util.concurrent.TimeoutException(Util.formatString("Timed out after %s waiting for a response from %s", Util.prettyPrintTime(timeout), entry.getKey()));
    }

    public String toString() {
        return "JGroupsBackupResponse{syncBackupCalls=" + this.syncBackupCalls + ", errors=" + this.errors + ", communicationErrors=" + this.communicationErrors + ", sendTimeNanos=" + this.sendTimeNanos + '}';
    }
}

