/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.loaders.AbstractCacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.decorators.SingletonStoreConfig;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlType(propOrder={})
@ConfigurationDoc(name="loader", desc="Responsible for loading/storing cache data from/to an external source.")
public class AbstractCacheStoreConfig
extends AbstractCacheLoaderConfig
implements CacheStoreConfig {
    private static final long serialVersionUID = 4607371052771122893L;
    @ConfigurationDocRef(bean=AbstractCacheStoreConfig.class, targetElement="setIgnoreModifications")
    protected Boolean ignoreModifications = false;
    @ConfigurationDocRef(bean=AbstractCacheStoreConfig.class, targetElement="setFetchPersistentState")
    protected Boolean fetchPersistentState = false;
    @ConfigurationDocRef(bean=AbstractCacheStoreConfig.class, targetElement="setPurgeOnStartup")
    protected Boolean purgeOnStartup = false;
    @ConfigurationDocRef(bean=AbstractCacheStoreConfig.class, targetElement="setPurgeSynchronously")
    protected Boolean purgeSynchronously = false;
    @ConfigurationDocRef(bean=AbstractCacheStoreConfig.class, targetElement="setPurgerThreads")
    protected Integer purgerThreads = 1;
    protected SingletonStoreConfig singletonStore = new SingletonStoreConfig();
    protected AsyncStoreConfig async = new AsyncStoreConfig();

    @Override
    public AsyncStoreConfig asyncStore() {
        this.async.setEnabled(true);
        this.async.setCacheStoreConfig(this);
        return this.async;
    }

    @Override
    public SingletonStoreConfig singletonStore() {
        this.singletonStore.setSingletonStoreEnabled(true);
        this.singletonStore.setCacheStoreConfig(this);
        return this.singletonStore;
    }

    @Override
    @XmlAttribute
    public Boolean isPurgeSynchronously() {
        return this.purgeSynchronously;
    }

    @Override
    @XmlAttribute
    public Integer getPurgerThreads() {
        return this.purgerThreads;
    }

    @XmlElement(name="properties")
    public TypedProperties getTypedProperties() {
        return this.properties;
    }

    public void setTypedProperties(TypedProperties tp) {
        this.properties = tp;
    }

    @Override
    public void setPurgeSynchronously(Boolean purgeSynchronously) {
        this.testImmutability("purgeSynchronously");
        this.purgeSynchronously = purgeSynchronously;
    }

    @Override
    public CacheStoreConfig purgeSynchronously(Boolean purgeSynchronously) {
        this.testImmutability("purgeSynchronously");
        this.purgeSynchronously = purgeSynchronously;
        return this;
    }

    @Deprecated
    public void setPurgerThreads(Integer purgerThreads) {
        this.testImmutability("purgerThreads");
        this.purgerThreads = purgerThreads;
    }

    @Override
    public CacheStoreConfig purgerThreads(Integer purgerThreads) {
        this.setPurgerThreads(purgerThreads);
        return this;
    }

    @Override
    @XmlAttribute
    public Boolean isFetchPersistentState() {
        return this.fetchPersistentState;
    }

    @Override
    public void setFetchPersistentState(Boolean fetchPersistentState) {
        this.testImmutability("fetchPersistentState");
        this.fetchPersistentState = fetchPersistentState;
    }

    @Override
    public CacheStoreConfig fetchPersistentState(Boolean fetchPersistentState) {
        this.testImmutability("fetchPersistentState");
        this.fetchPersistentState = fetchPersistentState;
        return this;
    }

    @Override
    public void setIgnoreModifications(Boolean ignoreModifications) {
        this.testImmutability("ignoreModifications");
        this.ignoreModifications = ignoreModifications;
    }

    @Override
    public CacheStoreConfig ignoreModifications(Boolean ignoreModifications) {
        this.testImmutability("ignoreModifications");
        this.ignoreModifications = ignoreModifications;
        return this;
    }

    @Override
    @XmlAttribute
    public Boolean isIgnoreModifications() {
        return this.ignoreModifications;
    }

    @Override
    @XmlAttribute
    public Boolean isPurgeOnStartup() {
        return this.purgeOnStartup;
    }

    @Override
    public CacheStoreConfig purgeOnStartup(Boolean purgeOnStartup) {
        this.testImmutability("purgeOnStartup");
        this.purgeOnStartup = purgeOnStartup;
        return this;
    }

    @Override
    public void setPurgeOnStartup(Boolean purgeOnStartup) {
        this.testImmutability("purgeOnStartup");
        this.purgeOnStartup = purgeOnStartup;
    }

    @Override
    @XmlElement(name="singletonStore")
    public SingletonStoreConfig getSingletonStoreConfig() {
        return this.singletonStore;
    }

    @Override
    public void setSingletonStoreConfig(SingletonStoreConfig singletonStoreConfig) {
        this.testImmutability("singletonStore");
        this.singletonStore = singletonStoreConfig;
    }

    @Override
    @XmlElement(name="async")
    public AsyncStoreConfig getAsyncStoreConfig() {
        return this.async;
    }

    @Override
    public void setAsyncStoreConfig(AsyncStoreConfig asyncStoreConfig) {
        this.testImmutability("async");
        this.async = asyncStoreConfig;
    }

    @Override
    public void accept(ConfigurationBeanVisitor v) {
        this.singletonStore.accept(v);
        this.async.accept(v);
        v.visitCacheLoaderConfig(this);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof AbstractCacheStoreConfig)) {
                return false;
            }
            AbstractCacheStoreConfig i = (AbstractCacheStoreConfig)obj;
            return this.equalsExcludingProperties(i);
        }
        return false;
    }

    protected boolean equalsExcludingProperties(Object obj) {
        AbstractCacheStoreConfig other = (AbstractCacheStoreConfig)obj;
        return Util.safeEquals(this.cacheLoaderClassName, other.cacheLoaderClassName) && this.ignoreModifications.equals(other.ignoreModifications) && this.fetchPersistentState.equals(other.fetchPersistentState) && Util.safeEquals(this.singletonStore, other.singletonStore) && Util.safeEquals(this.async, other.async) && Util.safeEquals(this.purgeSynchronously, other.purgeSynchronously) && Util.safeEquals(this.purgerThreads, other.purgerThreads);
    }

    public int hashCode() {
        return 31 * this.hashCodeExcludingProperties() + (this.properties == null ? 0 : this.properties.hashCode());
    }

    protected int hashCodeExcludingProperties() {
        int result = 17;
        result = 31 * result + (this.cacheLoaderClassName == null ? 0 : this.cacheLoaderClassName.hashCode());
        result = 31 * result + (this.ignoreModifications != false ? 0 : 1);
        result = 31 * result + (this.fetchPersistentState != false ? 0 : 1);
        result = 31 * result + (this.singletonStore == null ? 0 : this.singletonStore.hashCode());
        result = 31 * result + (this.async == null ? 0 : this.async.hashCode());
        result = 31 * result + (this.purgeOnStartup != false ? 0 : 1);
        result = 31 * result + this.purgerThreads;
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "className='" + this.cacheLoaderClassName + '\'' + ", ignoreModifications=" + this.ignoreModifications + ", fetchPersistentState=" + this.fetchPersistentState + ", properties=" + this.properties + ", purgeOnStartup=" + this.purgeOnStartup + "}," + ", singletonStore{" + this.singletonStore + '}' + ", async{" + this.async + '}' + ", purgeSynchronously{" + this.purgeSynchronously + '}' + ", purgerThreads{" + this.purgerThreads + '}';
    }

    @Override
    public AbstractCacheStoreConfig clone() {
        AbstractCacheStoreConfig clone = (AbstractCacheStoreConfig)super.clone();
        if (this.singletonStore != null) {
            clone.setSingletonStoreConfig(this.singletonStore.clone());
        }
        if (this.async != null) {
            clone.setAsyncStoreConfig(this.async.clone());
        }
        return clone;
    }
}

