/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexOverlay;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IndexingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<IndexingConfiguration> {
    private static final Log log = LogFactory.getLog(IndexingConfigurationBuilder.class);
    private Properties properties = new Properties();
    private Index index = Index.NONE;
    private boolean autoConfig;

    IndexingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    @Deprecated
    public IndexingConfigurationBuilder enable() {
        if (this.index == Index.NONE) {
            this.index = Index.ALL;
        }
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder disable() {
        this.index = Index.NONE;
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder enabled(boolean enabled) {
        if (this.index == Index.NONE & enabled) {
            this.index = Index.ALL;
        } else if (!enabled) {
            this.index = Index.NONE;
        }
        return this;
    }

    boolean enabled() {
        return this.index.isEnabled();
    }

    @Deprecated
    public IndexingConfigurationBuilder indexLocalOnly(boolean b) {
        if (b) {
            this.index = Index.LOCAL;
        }
        return this;
    }

    boolean indexLocalOnly() {
        return this.index.isLocalOnly();
    }

    public IndexingConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public IndexingConfigurationBuilder setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public IndexingConfigurationBuilder withProperties(Properties props) {
        this.properties = props;
        return this;
    }

    public IndexingConfigurationBuilder index(Index index) {
        this.index = index;
        return this;
    }

    public IndexingConfigurationBuilder autoConfig(boolean autoConfig) {
        this.autoConfig = autoConfig;
        return this;
    }

    public boolean autoConfig() {
        return this.autoConfig;
    }

    public void validate() {
        if (this.index.isEnabled() && this.clustering().cacheMode().isInvalidation()) {
            throw log.invalidConfigurationIndexingWithInvalidation();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.index.isEnabled()) {
            try {
                String clazz = "org.infinispan.query.Search";
                Util.loadClassStrict((String)clazz, (ClassLoader)globalConfig.classLoader());
            }
            catch (ClassNotFoundException e) {
                throw log.invalidConfigurationIndexingWithoutModule();
            }
        }
    }

    public IndexingConfiguration create() {
        TypedProperties typedProperties = TypedProperties.toTypedProperties((Properties)this.properties);
        if (this.autoConfig()) {
            if (this.clustering().cacheMode().isDistributed()) {
                IndexOverlay.DISTRIBUTED_INFINISPAN.apply(typedProperties);
            } else {
                IndexOverlay.NON_DISTRIBUTED_FS.apply(typedProperties);
            }
        }
        return new IndexingConfiguration(typedProperties, this.index, this.autoConfig);
    }

    public IndexingConfigurationBuilder read(IndexingConfiguration template) {
        this.index = template.index();
        this.properties = new Properties();
        TypedProperties templateProperties = template.properties();
        if (templateProperties != null) {
            for (Map.Entry entry : templateProperties.entrySet()) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public String toString() {
        return "IndexingConfigurationBuilder{index=" + (Object)((Object)this.index) + ", autoConfig=" + this.autoConfig + ", properties=" + this.properties + '}';
    }
}

