/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.persistence.file.SingleFileStore;

@BuiltBy(value=SingleFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=SingleFileStore.class)
public class SingleFileStoreConfiguration
extends AbstractStoreConfiguration {
    private final String location;
    private final int maxEntries;
    private final float fragmentationFactor;

    public SingleFileStoreConfiguration(boolean purgeOnStartup, boolean fetchPersistentState, boolean ignoreModifications, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore, boolean preload, boolean shared, Properties properties, String location, int maxEntries, float fragmentationFactor) {
        super(purgeOnStartup, fetchPersistentState, ignoreModifications, async, singletonStore, preload, shared, properties);
        this.location = location;
        this.maxEntries = maxEntries;
        this.fragmentationFactor = fragmentationFactor;
    }

    public String location() {
        return this.location;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public float fragmentationFactor() {
        return this.fragmentationFactor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SingleFileStoreConfiguration that = (SingleFileStoreConfiguration)o;
        if (this.maxEntries != that.maxEntries) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        return this.fragmentationFactor == that.fragmentationFactor;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + this.maxEntries;
        result = 31 * result + Float.floatToIntBits(this.fragmentationFactor);
        return result;
    }

    @Override
    public String toString() {
        return "SingleFileStoreConfiguration{location='" + this.location + '\'' + ", maxEntries=" + this.maxEntries + ", fragmentationFactor =" + this.fragmentationFactor + '}';
    }
}

