/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.OwnershipStatistics;
import org.infinispan.remoting.transport.Address;

public class ReplicatedConsistentHash
implements ConsistentHash {
    private final Hash hashFunction;
    private final int[] primaryOwners;
    private final List<Address> members;
    private final Set<Address> membersSet;
    private final Set<Integer> segments;

    public ReplicatedConsistentHash(Hash hashFunction, List<Address> members, int[] primaryOwners) {
        this.hashFunction = hashFunction;
        this.members = Collections.unmodifiableList(new ArrayList<Address>(members));
        this.membersSet = Collections.unmodifiableSet(new HashSet<Address>(members));
        this.primaryOwners = primaryOwners;
        HashSet<Integer> segmentIds = new HashSet<Integer>(primaryOwners.length);
        for (int i = 0; i < primaryOwners.length; ++i) {
            segmentIds.add(i);
        }
        this.segments = Collections.unmodifiableSet(segmentIds);
    }

    @Override
    public int getNumSegments() {
        return this.primaryOwners.length;
    }

    @Override
    public int getNumOwners() {
        return this.members.size();
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public Hash getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public int getSegment(Object key) {
        return (this.hashFunction.hash(key) & Integer.MAX_VALUE) % this.primaryOwners.length;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
        ArrayList<Address> owners = new ArrayList<Address>(this.members.size());
        owners.add(primaryOwner);
        for (Address member : this.members) {
            if (member.equals(primaryOwner)) continue;
            owners.add(member);
        }
        return owners;
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.members.get(this.primaryOwners[segmentId]);
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.membersSet.contains(owner)) {
            throw new IllegalArgumentException("The node is not a member : " + owner);
        }
        return this.segments;
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        int index = this.members.indexOf(owner);
        if (index == -1) {
            throw new IllegalArgumentException("The node is not a member : " + owner);
        }
        HashSet<Integer> primarySegments = new HashSet<Integer>();
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            if (this.primaryOwners[i] != index) continue;
            primarySegments.add(i);
        }
        return primarySegments;
    }

    @Override
    public String getRoutingTableAsString() {
        return Arrays.toString(this.primaryOwners);
    }

    @Override
    public Address locatePrimaryOwner(Object key) {
        return this.locatePrimaryOwnerForSegment(this.getSegment(key));
    }

    @Override
    public List<Address> locateOwners(Object key) {
        return this.locateOwnersForSegment(this.getSegment(key));
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        return this.membersSet;
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        return this.membersSet.contains(nodeAddress);
    }

    public String toString() {
        OwnershipStatistics stats = new OwnershipStatistics(this, this.members);
        StringBuilder sb = new StringBuilder("ReplicatedConsistentHash{");
        sb.append("ns = ").append(this.segments.size());
        sb.append(", owners = (").append(this.members.size()).append(")[");
        boolean first = true;
        for (Address a : this.members) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            int primaryOwned = stats.getPrimaryOwned(a);
            sb.append(a).append(": ").append(primaryOwned);
        }
        sb.append("]}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashFunction == null ? 0 : this.hashFunction.hashCode());
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        result = 31 * result + Arrays.hashCode(this.primaryOwners);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicatedConsistentHash other = (ReplicatedConsistentHash)obj;
        if (this.hashFunction == null ? other.hashFunction != null : !this.hashFunction.equals(other.hashFunction)) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return Arrays.equals(this.primaryOwners, other.primaryOwners);
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<ReplicatedConsistentHash> {
        public void doWriteObject(ObjectOutput output, ReplicatedConsistentHash ch) throws IOException {
            output.writeObject(ch.hashFunction);
            output.writeObject(ch.members);
            output.writeObject(ch.primaryOwners);
        }

        public ReplicatedConsistentHash doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            Hash hashFunction = (Hash)unmarshaller.readObject();
            List members = (List)unmarshaller.readObject();
            int[] primaryOwners = (int[])unmarshaller.readObject();
            return new ReplicatedConsistentHash(hashFunction, members, primaryOwners);
        }

        public Integer getId() {
            return 52;
        }

        public Set<Class<? extends ReplicatedConsistentHash>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHash.class);
        }
    }
}

