/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.tx;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.tx.TxDistributedCacheStream;
import org.infinispan.stream.impl.tx.TxDistributedDoubleCacheStream;
import org.infinispan.stream.impl.tx.TxDistributedIntCacheStream;

public class TxDistributedLongCacheStream<Original, K, V>
extends DistributedLongCacheStream<Original> {
    private final Address localAddress;
    private final LocalTxInvocationContext ctx;
    private final ConsistentHash hash;
    private final Function<? super CacheEntry<K, V>, ? extends Original> toOriginalFunction;

    TxDistributedLongCacheStream(AbstractCacheStream stream, Address localAddress, ConsistentHash hash, LocalTxInvocationContext ctx, Function<? super CacheEntry<K, V>, ? extends Original> toOriginalFunction) {
        super(stream);
        this.localAddress = localAddress;
        this.ctx = ctx;
        this.hash = hash;
        this.toOriginalFunction = toOriginalFunction;
    }

    @Override
    protected Supplier<Stream<Original>> supplierForSegments(ConsistentHash ch, IntSet targetSegments, Set<Object> excludedKeys, boolean primaryOnly) {
        return () -> {
            Supplier supplier = super.supplierForSegments(ch, targetSegments, excludedKeys, primaryOnly);
            Set set = this.ctx.getLookedUpEntries().values().stream().filter((? super T e) -> !this.isPrimaryOwner(ch, (CacheEntry)e)).map((? super T e) -> this.toOriginalFunction.apply((CacheEntry<K, V>)e)).collect(Collectors.toSet());
            Stream suppliedStream = supplier.get();
            if (!set.isEmpty()) {
                return Stream.concat(set.stream(), suppliedStream);
            }
            return suppliedStream;
        };
    }

    @Override
    protected <R> DistributedCacheStream<Original, R> cacheStream() {
        return new TxDistributedCacheStream(this, this.localAddress, this.hash, this.ctx, this.toOriginalFunction);
    }

    @Override
    protected DistributedIntCacheStream<Original> intCacheStream() {
        return new TxDistributedIntCacheStream(this, this.localAddress, this.hash, this.ctx, this.toOriginalFunction);
    }

    @Override
    protected DistributedDoubleCacheStream<Original> doubleCacheStream() {
        return new TxDistributedDoubleCacheStream(this, this.localAddress, this.hash, this.ctx, this.toOriginalFunction);
    }
}

