/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.Utils;

public final class Extensions {
    private final String documentation;
    private final int start;
    private final int end;

    public Extensions(String documentation, int start, int end) {
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (!ProtoFile.isValidTag(start)) {
            throw new IllegalArgumentException("Invalid start value: " + start);
        }
        if (!ProtoFile.isValidTag(end)) {
            throw new IllegalArgumentException("Invalid end value: " + end);
        }
        this.documentation = documentation;
        this.start = start;
        this.end = end;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Extensions)) {
            return false;
        }
        Extensions that = (Extensions)o;
        return this.end == that.end && this.start == that.start && this.documentation.equals(that.documentation);
    }

    public int hashCode() {
        int result = this.documentation.hashCode();
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation);
        builder.append("extensions ").append(this.start);
        if (this.start != this.end) {
            builder.append(" to ");
            if (this.end < 0x1FFFFFFF) {
                builder.append(this.end);
            } else {
                builder.append("max");
            }
        }
        return builder.append(";\n").toString();
    }
}

