/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.configuration.Builder;

public class SslConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<SslConfiguration> {
    private static final Log log = LogFactory.getLog(SslConfigurationBuilder.class);
    private boolean enabled = false;
    private String keyStoreFileName;
    private char[] keyStorePassword;
    private String trustStoreFileName;
    private char[] trustStorePassword;
    private SSLContext sslContext;

    protected SslConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder);
    }

    public SslConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public SslConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public SslConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SslConfigurationBuilder keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslConfigurationBuilder keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslConfigurationBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public SslConfigurationBuilder trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslConfigurationBuilder trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    @Override
    public void validate() {
        if (this.enabled) {
            if (this.sslContext == null) {
                if (this.keyStoreFileName == null) {
                    throw log.noSSLKeyManagerConfiguration();
                }
                if (this.keyStoreFileName != null && this.keyStorePassword == null) {
                    throw log.missingKeyStorePassword(this.keyStoreFileName);
                }
                if (this.trustStoreFileName == null) {
                    throw log.noSSLTrustManagerConfiguration();
                }
                if (this.trustStoreFileName != null && this.trustStorePassword == null) {
                    throw log.missingTrustStorePassword(this.trustStoreFileName);
                }
            } else if (this.keyStoreFileName != null || this.trustStoreFileName != null) {
                throw log.xorSSLContext();
            }
        }
    }

    @Override
    public SslConfiguration create() {
        return new SslConfiguration(this.enabled, this.keyStoreFileName, this.keyStorePassword, this.sslContext, this.trustStoreFileName, this.trustStorePassword);
    }

    public SslConfigurationBuilder read(SslConfiguration template) {
        this.enabled = template.enabled();
        this.keyStoreFileName = template.keyStoreFileName();
        this.keyStorePassword = template.keyStorePassword();
        this.sslContext = template.sslContext();
        this.trustStoreFileName = template.trustStoreFileName();
        this.trustStorePassword = template.trustStorePassword();
        return this;
    }
}

