/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.management.CacheStatisticsMXBean;
import org.infinispan.AdvancedCache;
import org.infinispan.stats.Stats;

public class RICacheStatistics
implements CacheStatisticsMXBean,
Serializable {
    private static final long serialVersionUID = -5589437411679003894L;
    private final AdvancedCache<?, ?> cache;
    private final AtomicLong unsupportCacheHits = new AtomicLong();
    private final AtomicLong unsupportCacheGetTotalTime = new AtomicLong();

    public RICacheStatistics(AdvancedCache<?, ?> cache) {
        this.cache = cache;
    }

    public void clear() {
        this.cache.getStats().reset();
    }

    public long getCacheHits() {
        return this.mapToSpecValidStat(this.cache.getStats().getHits() + this.unsupportCacheHits.longValue());
    }

    public float getCacheHitPercentage() {
        long hits = this.getCacheHits();
        if (hits == 0L) {
            return 0.0f;
        }
        return (float)hits / (float)this.getCacheGets() * 100.0f;
    }

    public long getCacheMisses() {
        return this.mapToSpecValidStat(this.cache.getStats().getMisses());
    }

    public float getCacheMissPercentage() {
        long misses = this.getCacheMisses();
        if (misses == 0L) {
            return 0.0f;
        }
        return (float)misses / (float)this.getCacheGets() * 100.0f;
    }

    public long getCacheGets() {
        Stats stats = this.cache.getStats();
        return stats.getHits() + stats.getMisses() + this.unsupportCacheHits.longValue();
    }

    public long getCachePuts() {
        return this.mapToSpecValidStat(this.cache.getStats().getStores());
    }

    public long getCacheRemovals() {
        Stats stats = this.cache.getStats();
        return this.mapToSpecValidStat(stats.getRemoveHits());
    }

    public long getCacheEvictions() {
        return this.mapToSpecValidStat(this.cache.getStats().getEvictions());
    }

    public float getAverageGetTime() {
        long unsupportedCacheGetTotalMillis = TimeUnit.NANOSECONDS.toMillis(this.unsupportCacheGetTotalTime.longValue());
        return TimeUnit.MILLISECONDS.toMicros(this.mapToSpecValidStat(this.cache.getStats().getAverageReadTime() + unsupportedCacheGetTotalMillis));
    }

    public float getAveragePutTime() {
        return TimeUnit.MILLISECONDS.toMicros(this.mapToSpecValidStat(this.cache.getStats().getAverageWriteTime()));
    }

    public float getAverageRemoveTime() {
        return TimeUnit.MILLISECONDS.toMicros(this.mapToSpecValidStat(this.cache.getStats().getAverageRemoveTime()));
    }

    public void increaseCacheHits(long number) {
        this.unsupportCacheHits.getAndAdd(number);
    }

    public void addGetTimeNano(long duration) {
        if (this.unsupportCacheGetTotalTime.get() <= Long.MAX_VALUE - duration) {
            this.unsupportCacheGetTotalTime.addAndGet(duration);
        } else {
            this.clear();
            this.unsupportCacheGetTotalTime.set(duration);
        }
    }

    private long mapToSpecValidStat(long stat) {
        return stat < 0L ? 0L : stat;
    }
}

