/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ExtendedModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandExtensions;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.factories.components.ModuleMetadataFileFinder;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ModuleProperties
extends Properties {
    private static final long serialVersionUID = 2558131508076199744L;
    private static final Log log = LogFactory.getLog(ModuleProperties.class);
    private Map<Byte, ModuleCommandFactory> commandFactories;
    private Map<Byte, ModuleCommandInitializer> commandInitializers;
    private Collection<Class<? extends ReplicableCommand>> moduleCommands;

    public static Collection<ModuleLifecycle> resolveModuleLifecycles(ClassLoader cl) {
        return ServiceFinder.load(ModuleLifecycle.class, cl);
    }

    public static Iterable<ModuleMetadataFileFinder> getModuleMetadataFiles(ClassLoader cl) {
        return ServiceFinder.load(ModuleMetadataFileFinder.class, cl);
    }

    public void loadModuleCommandHandlers(ClassLoader cl) {
        Set<ModuleCommandExtensions> moduleCmdExtLoader = ServiceFinder.load(ModuleCommandExtensions.class, cl);
        if (moduleCmdExtLoader.iterator().hasNext()) {
            this.commandFactories = new HashMap<Byte, ModuleCommandFactory>(1);
            this.commandInitializers = new HashMap<Byte, ModuleCommandInitializer>(1);
            this.moduleCommands = new HashSet<Class<? extends ReplicableCommand>>(1);
            for (ModuleCommandExtensions extension : moduleCmdExtLoader) {
                log.debugf("Loading module command extension SPI class: %s", (Object)extension);
                ExtendedModuleCommandFactory cmdFactory = extension.getModuleCommandFactory();
                ModuleCommandInitializer cmdInitializer = extension.getModuleCommandInitializer();
                for (Map.Entry<Byte, Class<? extends ReplicableCommand>> command : cmdFactory.getModuleCommands().entrySet()) {
                    byte id = command.getKey();
                    if (this.commandFactories.containsKey(id)) {
                        throw new IllegalArgumentException(String.format("Cannot use id %d for commands, as it is already in use by %s", id, this.commandFactories.get(id).getClass().getName()));
                    }
                    this.commandFactories.put(id, cmdFactory);
                    this.moduleCommands.add(command.getValue());
                    this.commandInitializers.put(id, cmdInitializer);
                }
            }
        } else {
            log.debugf("No module command extensions to load", new Object[0]);
            this.commandInitializers = Collections.emptyMap();
            this.commandFactories = Collections.emptyMap();
        }
    }

    public Collection<Class<? extends ReplicableCommand>> moduleCommands() {
        return this.moduleCommands;
    }

    public Map<Byte, ModuleCommandFactory> moduleCommandFactories() {
        return this.commandFactories;
    }

    public Map<Byte, ModuleCommandInitializer> moduleCommandInitializers() {
        return this.commandInitializers;
    }

    public Collection<Class<? extends CacheRpcCommand>> moduleCacheRpcCommands() {
        Collection<Class<? extends ReplicableCommand>> cmds = this.moduleCommands();
        if (cmds == null || cmds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends CacheRpcCommand>> cacheRpcCmds = new HashSet<Class<? extends CacheRpcCommand>>(2);
        for (Class<? extends ReplicableCommand> moduleCmdClass : cmds) {
            if (!CacheRpcCommand.class.isAssignableFrom(moduleCmdClass)) continue;
            cacheRpcCmds.add(moduleCmdClass);
        }
        return cacheRpcCmds;
    }

    public Collection<Class<? extends ReplicableCommand>> moduleOnlyReplicableCommands() {
        Collection<Class<? extends ReplicableCommand>> cmds = this.moduleCommands();
        if (cmds == null || cmds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends ReplicableCommand>> replicableOnlyCmds = new HashSet<Class<? extends ReplicableCommand>>(2);
        for (Class<? extends ReplicableCommand> moduleCmdClass : cmds) {
            if (CacheRpcCommand.class.isAssignableFrom(moduleCmdClass)) continue;
            replicableOnlyCmds.add(moduleCmdClass);
        }
        return replicableOnlyCmds;
    }
}

