/*
 * Decompiled with CFR 0.152.
 */
package protostream.com.squareup.protoparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import protostream.com.squareup.protoparser.Option;
import protostream.com.squareup.protoparser.Type;
import protostream.com.squareup.protoparser.Utils;

public final class EnumType
implements Type {
    private final String name;
    private final String fqname;
    private final String documentation;
    private final List<Option> options;
    private final List<Value> values;

    static void validateTagUniqueness(String type, List<Value> values) {
        LinkedHashSet<Integer> tags = new LinkedHashSet<Integer>();
        for (Value value : values) {
            int tag = value.getTag();
            if (tags.add(tag)) continue;
            throw new IllegalStateException("Duplicate tag " + tag + " in " + type);
        }
    }

    static void validateValueUniquenessInScope(String type, List<Type> nestedTypes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Type nestedType : nestedTypes) {
            if (!(nestedType instanceof EnumType)) continue;
            EnumType enumType = (EnumType)nestedType;
            for (Value value : enumType.getValues()) {
                String name = value.getName();
                if (names.add(name)) continue;
                throw new IllegalStateException("Duplicate enum name " + name + " in scope " + type);
            }
        }
    }

    public EnumType(String name, String fqname, String documentation, List<Option> options, List<Value> values) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (fqname == null) {
            throw new NullPointerException("fqname");
        }
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        EnumType.validateTagUniqueness(fqname, values);
        this.name = name;
        this.fqname = fqname;
        this.documentation = documentation;
        this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
        this.values = Collections.unmodifiableList(new ArrayList<Value>(values));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fqname;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public List<Option> getOptions() {
        return this.options;
    }

    public List<Value> getValues() {
        return this.values;
    }

    @Override
    public List<Type> getNestedTypes() {
        return Collections.emptyList();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnumType)) {
            return false;
        }
        EnumType that = (EnumType)other;
        return this.name.equals(that.name) && this.fqname.equals(that.fqname) && this.documentation.equals(that.documentation) && this.options.equals(that.options) && this.values.equals(that.values);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fqname.hashCode();
        result = 31 * result + this.documentation.hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation);
        builder.append("enum ").append(this.name).append(" {");
        if (!this.options.isEmpty()) {
            builder.append('\n');
            for (Option option : this.options) {
                Utils.appendIndented(builder, option.toDeclaration());
            }
        }
        if (!this.values.isEmpty()) {
            builder.append('\n');
            for (Value value : this.values) {
                Utils.appendIndented(builder, value.toString());
            }
        }
        return builder.append("}\n").toString();
    }

    public static final class Value {
        private final String name;
        private final int tag;
        private final String documentation;
        private final List<Option> options;

        public Value(String name, int tag, String documentation, List<Option> options) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (documentation == null) {
                throw new NullPointerException("documentation");
            }
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.name = name;
            this.tag = tag;
            this.documentation = documentation;
            this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
        }

        public String getName() {
            return this.name;
        }

        public int getTag() {
            return this.tag;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public List<Option> getOptions() {
            return this.options;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Value)) {
                return false;
            }
            Value that = (Value)other;
            return this.name.equals(that.name) && this.tag == that.tag && this.documentation.equals(that.documentation) && this.options.equals(that.options);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.tag;
            result = 31 * result + this.documentation.hashCode();
            result = 31 * result + this.options.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Utils.appendDocumentation(builder, this.documentation);
            builder.append(this.name).append(" = ").append(this.tag);
            if (!this.options.isEmpty()) {
                builder.append(" [\n");
                for (Option option : this.options) {
                    Utils.appendIndented(builder, option.toString());
                }
                builder.append(']');
            }
            return builder.append(";\n").toString();
        }
    }
}

