/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.UUID;
import java.util.function.Function;
import org.infinispan.commons.util.Util;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.hibernate.cache.commons.util.FutureUpdate;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.InvocationAfterCompletion;

public class FutureUpdateSynchronization
extends InvocationAfterCompletion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(FutureUpdateSynchronization.class);
    private final UUID uuid = Util.threadLocalRandomUUID();
    private final Object key;
    private final Object value;
    private final InfinispanDataRegion region;
    private final long sessionTimestamp;
    private final FunctionalMap.ReadWriteMap<Object, Object> rwMap;

    public FutureUpdateSynchronization(SessionAccess.TransactionCoordinatorAccess tc, FunctionalMap.ReadWriteMap<Object, Object> rwMap, boolean requiresTransaction, Object key, Object value, InfinispanDataRegion region, long sessionTimestamp) {
        super(tc, requiresTransaction);
        this.rwMap = rwMap;
        this.key = key;
        this.value = value;
        this.region = region;
        this.sessionTimestamp = sessionTimestamp;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    protected void invoke(boolean success) {
        if (this.sessionTimestamp < this.region.getLastRegionInvalidation()) {
            success = false;
        }
        FutureUpdate futureUpdate = new FutureUpdate(this.uuid, this.region.nextTimestamp(), success ? this.value : null);
        while (true) {
            try {
                this.rwMap.eval(this.key, (Function)futureUpdate).join();
                return;
            }
            catch (Exception e) {
                log.failureInAfterCompletion(e);
                continue;
            }
            break;
        }
    }
}

