/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.api.async.AsyncCache;
import org.infinispan.api.async.AsyncCaches;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.HotRodAsyncCache;
import org.infinispan.hotrod.configuration.RemoteCacheConfiguration;

public class HotRodAsyncCaches
implements AsyncCaches {
    private final HotRod hotrod;

    HotRodAsyncCaches(HotRod hotrod) {
        this.hotrod = hotrod;
    }

    public <K, V> CompletionStage<AsyncCache<K, V>> create(String name, CacheConfiguration cacheConfiguration) {
        RemoteCacheConfiguration configuration = RemoteCacheConfiguration.fromCacheConfiguration(name, cacheConfiguration);
        return this.hotrod.transport.getRemoteCache(name, configuration).thenApply(r -> new HotRodAsyncCache(this.hotrod, r));
    }

    public <K, V> CompletionStage<AsyncCache<K, V>> create(String name, String template) {
        RemoteCacheConfiguration configuration = RemoteCacheConfiguration.fromTemplate(name, template);
        return this.hotrod.transport.getRemoteCache(name, configuration).thenApply(r -> new HotRodAsyncCache(this.hotrod, r));
    }

    public <K, V> CompletionStage<AsyncCache<K, V>> get(String name) {
        return this.hotrod.transport.getRemoteCache(name).thenApply(r -> new HotRodAsyncCache(this.hotrod, r));
    }

    public CompletionStage<Void> remove(String name) {
        return this.hotrod.transport.removeCache(name);
    }

    public CompletionStage<Set<String>> names() {
        return this.hotrod.transport.getCacheNames();
    }

    public CompletionStage<Void> createTemplate(String name, CacheConfiguration cacheConfiguration) {
        return null;
    }

    public CompletionStage<Void> removeTemplate(String name) {
        return null;
    }

    public CompletionStage<Set<String>> templateNames() {
        return this.hotrod.transport.getTemplateNames();
    }
}

