/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.CloseableIterable;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.sync.SyncCache;
import org.infinispan.api.sync.SyncCacheEntryProcessor;
import org.infinispan.api.sync.SyncQuery;
import org.infinispan.api.sync.SyncStreamingCache;
import org.infinispan.api.sync.events.cache.SyncCacheEntryListener;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.HotRodSyncContainer;
import org.infinispan.hotrod.HotRodSyncQuery;
import org.infinispan.hotrod.HotRodSyncStreamingCache;
import org.infinispan.hotrod.SyncToAsyncEntryProcessor;
import org.infinispan.hotrod.impl.Util;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class HotRodSyncCache<K, V>
implements SyncCache<K, V> {
    private final HotRod hotrod;
    private final RemoteCache<K, V> remoteCache;

    HotRodSyncCache(HotRod hotrod, RemoteCache<K, V> remoteCache) {
        this.hotrod = hotrod;
        this.remoteCache = remoteCache;
    }

    private <E> E blockingGet(Single<E> single) {
        return (E)single.blockingGet();
    }

    public String name() {
        return this.remoteCache.getName();
    }

    public CacheConfiguration configuration() {
        return Util.await(this.remoteCache.configuration());
    }

    public HotRodSyncContainer container() {
        return this.hotrod.sync();
    }

    public CacheEntry<K, V> getEntry(K key, CacheOptions options) {
        return Util.await(this.remoteCache.getEntry(key, options));
    }

    public CacheEntry<K, V> put(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.put(key, value, options));
    }

    public void set(K key, V value, CacheWriteOptions options) {
        Util.await(this.remoteCache.set(key, value, options));
    }

    public CacheEntry<K, V> putIfAbsent(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.putIfAbsent(key, value, options));
    }

    public boolean setIfAbsent(K key, V value, CacheWriteOptions options) {
        return Util.await(this.remoteCache.setIfAbsent(key, value, options));
    }

    public boolean replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return Util.await(this.remoteCache.replace(key, value, version, options));
    }

    public CacheEntry<K, V> getOrReplaceEntry(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return Util.await(this.remoteCache.getOrReplaceEntry(key, value, version, options));
    }

    public boolean remove(K key, CacheOptions options) {
        return Util.await(this.remoteCache.remove(key, options));
    }

    public boolean remove(K key, CacheEntryVersion version, CacheOptions options) {
        return Util.await(this.remoteCache.remove(key, version, options));
    }

    public CacheEntry<K, V> getAndRemove(K key, CacheOptions options) {
        return Util.await(this.remoteCache.getAndRemove(key, options));
    }

    public CloseableIterable<K> keys(CacheOptions options) {
        throw new UnsupportedOperationException();
    }

    public CloseableIterable<CacheEntry<K, V>> entries(CacheOptions options) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<K, V> entries, CacheWriteOptions options) {
        Util.await(this.remoteCache.putAll(entries, options));
    }

    public Map<K, V> getAll(Set<K> keys, CacheOptions options) {
        return (Map)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(this.remoteCache.getAll(keys, options))).collect(Collectors.toMap(CacheEntry::key, CacheEntry::value)));
    }

    public Map<K, V> getAll(CacheOptions options, K ... keys) {
        return (Map)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(this.remoteCache.getAll(options, keys))).collect(Collectors.toMap(CacheEntry::key, CacheEntry::value)));
    }

    public Set<K> removeAll(Set<K> keys, CacheWriteOptions options) {
        return (Set)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(this.remoteCache.removeAll(keys, options))).collect(Collectors.toSet()));
    }

    public Map<K, CacheEntry<K, V>> getAndRemoveAll(Set<K> keys, CacheWriteOptions options) {
        return (Map)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(this.remoteCache.getAndRemoveAll(keys, options))).collect(Collectors.toMap(CacheEntry::key, ce -> ce)));
    }

    public long estimateSize(CacheOptions options) {
        return Util.await(this.remoteCache.estimateSize(options));
    }

    public void clear(CacheOptions options) {
        Util.await(this.remoteCache.clear(options));
    }

    public <R> SyncQuery<K, V, R> query(String query, CacheOptions options) {
        return new HotRodSyncQuery(query, options);
    }

    public AutoCloseable listen(SyncCacheEntryListener<K, V> listener) {
        throw new UnsupportedOperationException();
    }

    public <T> Set<CacheEntryProcessorResult<K, T>> process(Set<K> keys, SyncCacheEntryProcessor<K, V, T> processor, CacheProcessorOptions options) {
        Flow.Publisher<CacheEntryProcessorResult<K, T>> flowPublisher = this.remoteCache.process(keys, new SyncToAsyncEntryProcessor<K, V, T>(processor), (CacheOptions)options);
        return (Set)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(flowPublisher)).collect(Collectors.toSet()));
    }

    public <T> Set<CacheEntryProcessorResult<K, T>> processAll(SyncCacheEntryProcessor<K, V, T> processor, CacheProcessorOptions options) {
        Flow.Publisher<CacheEntryProcessorResult<K, T>> flowPublisher = this.remoteCache.processAll(new SyncToAsyncEntryProcessor<K, V, T>(processor), options);
        return (Set)this.blockingGet(Flowable.fromPublisher((Publisher)FlowAdapters.toPublisher(flowPublisher)).collect(Collectors.toSet()));
    }

    public SyncStreamingCache<K> streaming() {
        return new HotRodSyncStreamingCache<K>(this.hotrod, this.remoteCache);
    }
}

