/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class AuthOperation
extends HotRodOperation<byte[]> {
    private final Channel channel;
    private final String saslMechanism;
    private final byte[] response;

    public AuthOperation(OperationContext operationContext, Channel channel, String saslMechanism, byte[] response) {
        super(operationContext, (short)35, (short)36, CacheOptions.DEFAULT);
        this.channel = channel;
        this.saslMechanism = saslMechanism;
        this.response = response;
    }

    @Override
    public CompletableFuture<byte[]> execute() {
        if (!this.channel.isActive()) {
            throw Log.HOTROD.channelInactive(this.channel.remoteAddress(), this.channel.remoteAddress());
        }
        byte[] saslMechBytes = this.saslMechanism.getBytes(HOTROD_STRING_CHARSET);
        this.scheduleRead(this.channel);
        Codec codec = this.operationContext.getCodec();
        ByteBuf buf = this.channel.alloc().buffer(codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(saslMechBytes) + ByteBufUtil.estimateArraySize(this.response));
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, saslMechBytes);
        ByteBufUtil.writeArray(buf, this.response);
        this.channel.writeAndFlush((Object)buf);
        return this;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        boolean complete = buf.readUnsignedByte() > 0;
        byte[] challenge = ByteBufUtil.readArray(buf);
        this.complete(complete ? null : challenge);
    }
}

