/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transaction.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transaction.entry.Modification;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class PrepareTransactionOperation
extends RetryOnFailureOperation<Integer> {
    private final Xid xid;
    private final boolean onePhaseCommit;
    private final List<Modification> modifications;
    private final boolean recoverable;
    private final long timeoutMs;
    private boolean retry;

    public PrepareTransactionOperation(OperationContext operationContext, Xid xid, boolean onePhaseCommit, List<Modification> modifications, boolean recoverable, long timeoutMs) {
        super(operationContext, (short)125, (short)126, CacheOptions.DEFAULT, null);
        this.xid = xid;
        this.onePhaseCommit = onePhaseCommit;
        this.modifications = modifications;
        this.recoverable = recoverable;
        this.timeoutMs = timeoutMs;
    }

    public boolean shouldRetry() {
        return this.retry;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (status == 0) {
            this.complete(buf.readInt());
        } else {
            this.retry = status == 1;
            this.complete(0);
        }
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.retry = false;
        this.scheduleRead(channel);
        Codec codec = this.operationContext.getCodec();
        ByteBuf buf = channel.alloc().buffer(this.estimateSize(codec));
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeXid(buf, this.xid);
        buf.writeBoolean(this.onePhaseCommit);
        buf.writeBoolean(this.recoverable);
        buf.writeLong(this.timeoutMs);
        ByteBufUtil.writeVInt(buf, this.modifications.size());
        for (Modification m : this.modifications) {
            m.writeTo(buf, codec);
        }
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (this.modifications.isEmpty()) {
            super.fetchChannelAndInvoke(retryCount, failedServers);
        } else {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.modifications.get(0).getKey(), failedServers, this.operationContext.getCacheNameBytes(), this);
        }
    }

    private int estimateSize(Codec codec) {
        int size = codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateXidSize(this.xid) + 1 + ByteBufUtil.estimateVIntSize(this.modifications.size());
        for (Modification modification : this.modifications) {
            size += modification.estimateSize(codec);
        }
        return size;
    }
}

