/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transaction.entry;

public enum ControlByte {
    NOT_READ(1),
    NON_EXISTING(2),
    REMOVE_OP(4);

    private final byte bitSet;

    private ControlByte(int bitSet) {
        this.bitSet = (byte)bitSet;
    }

    public static String prettyPrint(byte bitSet) {
        StringBuilder builder = new StringBuilder("[");
        if (NOT_READ.hasFlag(bitSet)) {
            builder.append("NOT_READ");
        } else if (NON_EXISTING.hasFlag(bitSet)) {
            builder.append("NON_EXISTING");
        } else {
            builder.append("READ");
        }
        if (REMOVE_OP.hasFlag(bitSet)) {
            builder.append(", REMOVED");
        }
        return builder.append("]").toString();
    }

    public byte set(byte bitSet) {
        return (byte)(bitSet | this.bitSet);
    }

    public boolean hasFlag(byte bitSet) {
        return (bitSet & this.bitSet) == this.bitSet;
    }

    public byte bit() {
        return this.bitSet;
    }
}

