/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.remote;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.management.MBeanServer;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheListenerAdapter;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.jcache.MutableJCacheEntry;
import org.infinispan.jcache.logging.Log;
import org.infinispan.jcache.remote.ConfigurationAdapter;
import org.infinispan.jcache.remote.JCacheNotifier;
import org.infinispan.jcache.remote.LocalStatistics;
import org.infinispan.jcache.remote.RemoteCacheWithCacheStore;
import org.infinispan.jcache.remote.RemoteCacheWithStats;
import org.infinispan.jcache.remote.RemoteCacheWithSyncListeners;

public class JCache<K, V>
extends AbstractJCache<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JCache.class, Log.class);
    private volatile boolean isClosed = false;
    private final RemoteCache<K, V> cacheWithoutStats;
    private final RemoteCache<K, V> cache;
    private final RemoteCache<K, V> cacheWithCacheStore;
    private final LocalStatistics stats;

    public JCache(RemoteCache<K, V> cache, RemoteCache<K, V> cacheForceReturnValue, CacheManager cacheManager, ConfigurationAdapter<K, V> configurationAdapter) {
        super(configurationAdapter.getConfiguration(), cacheManager, new JCacheNotifier());
        this.setCacheLoader((CompleteConfiguration)this.configuration);
        this.setCacheWriter((CompleteConfiguration)this.configuration);
        this.stats = new LocalStatistics();
        this.cacheWithoutStats = cache;
        this.cache = new RemoteCacheWithStats<K, V>(new RemoteCacheWithSyncListeners<K, V>(cacheForceReturnValue, this.notifier, this), this.stats);
        this.cacheWithCacheStore = new RemoteCacheWithCacheStore<K, V>(this.cache, this.jcacheLoader, this.jcacheWriter, this.configuration){

            @Override
            protected void onLoad(K key, V value) {
                JCache.this.put(JCache.this.cache, JCache.this.cache, key, value, false);
            }
        };
        this.addConfigurationListeners();
        if (this.configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (this.configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
    }

    public V get(K key) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        Object value = this.cacheWithCacheStore.get(key);
        if (value != null) {
            this.updateTTLForAccessed((BasicCache)this.cache, key, value);
        }
        return (V)value;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        InfinispanCollections.assertNotNullEntries(keys, (String)"keys");
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> result = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public boolean containsKey(K key) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        return this.cache.containsKey(key);
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.checkNotClosed();
        this.checkNotNull(keys, "keys");
        if (this.jcacheLoader == null) {
            this.setListenerCompletion(completionListener);
        } else {
            this.loadAllFromJCacheLoader(keys, replaceExistingValues, completionListener, (BasicCache)this.cache, (BasicCache)this.cache);
        }
    }

    public void put(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        this.writeToCacheWriter(key, value);
        this.put((BasicCache)this.cache, (BasicCache)this.cacheWithoutStats, key, value, false);
    }

    private void writeToCacheWriter(K key, V value) {
        if (!this.configuration.isWriteThrough() || this.jcacheWriter == null) {
            return;
        }
        try {
            this.jcacheWriter.write((Cache.Entry)new JCacheEntry(key, value));
        }
        catch (Exception ex) {
            throw Exceptions.launderCacheWriterException((Exception)ex);
        }
    }

    private void removeFromCacheWriter(K key) {
        if (!this.configuration.isWriteThrough() || this.jcacheWriter == null) {
            return;
        }
        try {
            this.jcacheWriter.delete(key);
        }
        catch (Exception ex) {
            throw Exceptions.launderCacheWriterException((Exception)ex);
        }
    }

    public V getAndPut(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        Object prev = this.put((BasicCache)this.cache, (BasicCache)this.cache, key, value, false);
        this.writeToCacheWriter(key, value);
        return (V)prev;
    }

    public void putAll(Map<? extends K, ? extends V> inputMap) {
        this.checkNotClosed();
        InfinispanCollections.assertNotNullEntries(inputMap, (String)"inputMap");
        for (Map.Entry<K, V> e : inputMap.entrySet()) {
            K key = e.getKey();
            V value = e.getValue();
            this.put(key, value);
        }
    }

    public boolean putIfAbsent(K key, V value) {
        boolean put;
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        boolean bl = put = this.put((BasicCache)this.cache, (BasicCache)this.cache, key, value, true) == null;
        if (put) {
            this.writeToCacheWriter(key, value);
        }
        return put;
    }

    public boolean remove(K key) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.removeFromCacheWriter(key);
        return this.cache.remove(key) != null;
    }

    public boolean remove(K key, V oldValue) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(oldValue, "oldValue");
        boolean removed = this.remove((BasicCache)this.cache, key, oldValue);
        if (removed) {
            this.removeFromCacheWriter(key);
        }
        return removed;
    }

    public V getAndRemove(K key) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        Object prev = this.cache.remove(key);
        this.removeFromCacheWriter(key);
        if (prev != null) {
            this.stats.incrementCacheHits();
        } else {
            this.stats.incrementCacheMisses();
        }
        return (V)prev;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(oldValue, "oldValue");
        this.checkNotNull(newValue, "newValue");
        boolean replaced = this.replace((BasicCache)this.cache, (BasicCache)this.cache, key, oldValue, newValue, true);
        if (replaced) {
            this.writeToCacheWriter(key, newValue);
        }
        return replaced;
    }

    public boolean replace(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        boolean replaced = this.replace((BasicCache)this.cache, (BasicCache)this.cacheWithoutStats, key, null, value, false);
        if (replaced) {
            this.writeToCacheWriter(key, value);
        } else {
            this.stats.incrementCacheMisses();
        }
        return replaced;
    }

    public V getAndReplace(K key, V value) {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(value, "value");
        Object prev = this.replace((BasicCache)this.cache, key, value);
        if (prev != null) {
            this.writeToCacheWriter(key, value);
        } else {
            this.stats.incrementCacheMisses();
        }
        return (V)prev;
    }

    public void removeAll(Set<? extends K> keys) {
        this.checkNotClosed();
        InfinispanCollections.assertNotNullEntries(keys, (String)"keys");
        for (K k : keys) {
            this.remove(k);
        }
    }

    public void removeAll() {
        this.checkNotClosed();
        try (CloseableIterator it = this.cacheWithoutStats.keySet().iterator();){
            while (it.hasNext()) {
                this.remove(it.next());
            }
        }
    }

    public void clear() {
        this.checkNotClosed();
        this.cache.clear();
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.checkNotClosed();
        this.checkNotNull(key, "key");
        this.checkNotNull(entryProcessor, "entryProcessor");
        if (log.isTraceEnabled()) {
            log.tracef("Invoke entry processor %s for key=%s", entryProcessor, key);
        }
        Object oldValue = this.cache.get(key);
        MutableJCacheEntry<K, Object> mutable = this.createMutableCacheEntry(oldValue, key);
        Object ret = this.processEntryProcessor(mutable, entryProcessor, arguments);
        switch (mutable.getOperation()) {
            case NONE: {
                break;
            }
            case ACCESS: {
                this.updateTTLForAccessed((BasicCache)this.cache, key, oldValue);
                break;
            }
            case UPDATE: {
                Object newValue = mutable.getNewValue();
                if (newValue == null) {
                    throw new EntryProcessorException();
                }
                if (oldValue != null) {
                    this.replace((BasicCache)this.cache, (BasicCache)this.cacheWithoutStats, key, oldValue, newValue, true);
                } else {
                    this.put((BasicCache)this.cache, (BasicCache)this.cache, key, newValue, true);
                }
                this.writeToCacheWriter(key, newValue);
                break;
            }
            case REMOVE: {
                this.cache.remove(key);
                this.removeFromCacheWriter(key);
            }
        }
        return (T)ret;
    }

    private MutableJCacheEntry<K, V> createMutableCacheEntry(V safeOldValue, K key) {
        return new MutableJCacheEntry(this.configuration.isReadThrough() ? this.cacheWithCacheStore : this.cache, this.cacheWithoutStats, key, safeOldValue);
    }

    public String getName() {
        return this.cache.getName();
    }

    public void close() {
        super.close();
        this.cache.stop();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.notifier.addListener(listenerCfg, (AbstractJCache)this, this.notifier);
        this.addCacheEntryListenerConfiguration(listenerCfg);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        this.notifier.removeListener(listenerCfg, (AbstractJCache)this);
        this.removeCacheEntryListenerConfiguration(listenerCfg);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkNotClosed();
        return new Itr();
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected Object getCacheStatisticsMXBean() {
        return this.stats;
    }

    protected AbstractJCache<K, V> checkNotClosed() {
        if (this.isClosed()) {
            throw log.cacheClosed();
        }
        return this;
    }

    protected void addListener(AbstractJCacheListenerAdapter<K, V> listenerAdapter) {
        this.cache.addClientListener(listenerAdapter);
    }

    protected void removeListener(AbstractJCacheListenerAdapter<K, V> listenerAdapter) {
        this.cache.removeClientListener(listenerAdapter);
    }

    protected void evict(K key) {
    }

    protected void addCacheLoaderAdapter(CacheLoader<K, V> cacheLoader) {
    }

    protected void addCacheWriterAdapter(CacheWriter<? super K, ? super V> cacheWriter) {
    }

    private class Itr
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<K> it;
        private Cache.Entry<K, V> current;
        private Cache.Entry<K, V> next;

        Itr() {
            this.it = JCache.this.cache.keySet().stream().collect(Collectors.toSet()).iterator();
            this.fetchNext();
        }

        private void fetchNext() {
            if (this.it.hasNext()) {
                Object key = this.it.next();
                Object value = JCache.this.cache.get(key);
                this.next = new JCacheEntry(key, value);
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.next == null) {
                this.fetchNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Cache.Entry ret = this.next;
            JCache.this.updateTTLForAccessed(JCache.this.cache, this.next.getKey(), this.next.getValue());
            this.current = this.next;
            this.fetchNext();
            return ret;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.getKey();
            this.current = null;
            JCache.this.cache.remove(k);
            JCache.this.removeFromCacheWriter(k);
        }
    }
}

